<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Http;

class GeoHelper
{
    /**
     * Get latitude and longitude from a full address string
     *
     * @param string $address
     * @return array
     */
    public static function getLatLongFromAddress(string $address): array
    {
        if (empty($address)) {
            return [
                'latitude'  => null,
                'longitude' => null
            ];
        }

        try {
            $response = Http::get('https://maps.googleapis.com/maps/api/geocode/json', [
                'address' => $address,
                'key'     => env('GOOGLE_MAPS_API_KEY')
            ]);

            if (
                $response->successful() &&
                isset($response['results'][0]['geometry']['location'])
            ) {
                return [
                    'latitude'  => $response['results'][0]['geometry']['location']['lat'],
                    'longitude' => $response['results'][0]['geometry']['location']['lng']
                ];
            }
        } catch (\Exception $e) {
            \Log::error('Geocoding failed: ' . $e->getMessage());
        }

        return [
            'latitude'  => null,
            'longitude' => null
        ];
    }
}
