<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class AdminDashboardController extends Controller
{

public function index()
{
    /* ================= USER COUNTS ================= */

    $warehouseStats = DB::table('warehouses')->selectRaw("
        SUM(status = 'active') as active,
        SUM(status = 'pending_admin') as pending,
        SUM(status = 'rejected') as rejected
    ")->first();

    $storeStats = DB::table('stores')->selectRaw("
        SUM(status = 'active') as active,
        SUM(status = 'pending_admin') as pending,
        SUM(status = 'rejected') as rejected
    ")->first();

    $riderStats = DB::table('riders')->selectRaw("
        SUM(status = 'active') as active,
        SUM(status = 'pending_admin') as pending,
        SUM(status = 'rejected') as rejected
    ")->first();

    $customerStats = DB::table('customers')->selectRaw("
        SUM(status = 'active') as active,
        SUM(status = 'blocked') as blocked
    ")->first();

    /* ================= DELIVERY PRICE ================= */

    $deliveryPrice = DB::table('delivery_prices')
        ->where('is_default', 1)
        ->first();

    /* ================= PENDING USERS (LIMITED – OK FOR DASHBOARD) ================= */

    $pendingWarehouses = DB::table('warehouses')
        ->where('status', 'pending_admin')
        ->latest()
        ->get();

    $pendingStores = DB::table('stores')
        ->where('status', 'pending_admin')
        ->latest()
        ->get();

    $pendingRiders = DB::table('riders')
        ->where('status', 'pending_admin')
        ->latest()
        ->get();

    /* ================= PENDING BANK APPROVALS ================= */

    $warehouseBanks = DB::table('warehouses')
        ->select(
            'id as owner_id',
            'warehouse_name as owner_name',
            DB::raw("'warehouse' as type"),
            'created_at'
        )
        ->where('bank_status', 'pending')
        ->where('status', 'active');

    $storeBanks = DB::table('stores')
        ->select(
            'id as owner_id',
            'store_name as owner_name',
            DB::raw("'store' as type"),
            'created_at'
        )
        ->where('bank_status', 'pending')
        ->where('status', 'active');

    $riderBanks = DB::table('riders')
        ->select(
            'id as owner_id',
            'name as owner_name',
            DB::raw("'rider' as type"),
            'created_at'
        )
        ->where('bank_status', 'pending')
        ->where('status', 'active');

    $pendingBanks = $warehouseBanks
        ->unionAll($storeBanks)
        ->unionAll($riderBanks)
        ->orderByDesc('created_at')
        ->get();


    /* ================= ORDER STATS ================= */

    $orderStats = DB::table('orders')
        ->select('status', DB::raw('COUNT(*) as total'))
        ->groupBy('status')
        ->pluck('total', 'status');

    $totalOrders = $orderStats->sum();

    /* ================= PRODUCT STATS ================= */

    $warehouseProductStats = DB::table('warehouse_products')->selectRaw("
        COUNT(*) as total,
        SUM(product_active = 1) as active
    ")->first();

    $storeProductStats = DB::table('store_products')->selectRaw("
        COUNT(*) as total,
        SUM(product_active = 1) as active
    ")->first();

    $productStats = (object) [
        'total'  => $warehouseProductStats->total + $storeProductStats->total,
        'active' => $warehouseProductStats->active + $storeProductStats->active,
    ];

    /* ================= PENDING PRODUCT APPROVALS (GROUPED BY USER) ================= */

    // Warehouse pending products (grouped by warehouse)
    $pendingWarehouseProducts = DB::table('warehouse_products as wp')
        ->join('warehouses as w', 'w.id', '=', 'wp.warehouse_id')
        ->where('wp.status', 'pending')
        ->select(
            'w.id as owner_id',
            'w.warehouse_name as owner_name',
            DB::raw("'warehouse' as type"),
            DB::raw('COUNT(wp.id) as pending_count'),
            DB::raw('MAX(wp.created_at) as last_requested_at')
        )
        ->groupBy('w.id', 'w.warehouse_name')
        ->get();

    // Store pending products (grouped by store)
    $pendingStoreProducts = DB::table('store_products as sp')
        ->join('stores as s', 's.id', '=', 'sp.store_id')
        ->where('sp.status', 'pending')
        ->select(
            's.id as owner_id',
            's.store_name as owner_name',
            DB::raw("'store' as type"),
            DB::raw('COUNT(sp.id) as pending_count'),
            DB::raw('MAX(sp.created_at) as last_requested_at')
        )
        ->groupBy('s.id', 's.store_name')
        ->get();

    // Merge + sort (NO DUPLICATES, ALL USERS)
    $pendingProducts = $pendingWarehouseProducts
        ->merge($pendingStoreProducts)
        ->sortByDesc('last_requested_at')
        ->values();

    return view('admin.dashboard', compact(
        'deliveryPrice',

        'warehouseStats',
        'storeStats',
        'riderStats',
        'customerStats',
        'pendingWarehouses',
        'pendingStores',
        'pendingRiders',
        'pendingBanks',
        'pendingProducts',
        'orderStats',
        'totalOrders',
        'productStats'
    ));
}

}

