<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    // public function index()
    // {
    //     $orders = Order::with([
    //         'rider',
    //         'riderRequest',
    //         ])
    //         ->where('status', '!=', 'pending_payment')
    //         ->latest()
    //         ->paginate(20);
    //     return view('admin.orders.index', compact('orders'));
    // }

    public function index(Request $request)
    {
        $orders = Order::with(['rider', 'riderRequest']);

        if ($request->filled('status')) {
            $orders->where('status', $request->status);
        }

        if ($request->has('customer_id')) {
            $orders->where('user_type', 'customer')
                ->where('user_id', $request->customer_id);
        }

        if ($request->has('warehouse_id')) {
            $orders->where('approved_by', $request->warehouse_id)
                ->where('approved_by_user_type', 'warehouse');
        }

        if ($request->has('store_id') && $request->type === 'sales') {
            $orders->where('approved_by', $request->store_id)
                ->where('approved_by_user_type', 'store');
        }

        if ($request->has('store_id') && $request->type === 'purchase') {
            $orders->where('user_type', 'store')
                ->where('user_id', $request->store_id);
        }

        $orders->where('status', '!=', 'pending_payment');

        $orders = $orders->latest()->get();

        return view('admin.orders.index', compact('orders'));
    }


    public function show($id)
    {
        $order = Order::with([
            'items.product',
            'customerBuyer',
            'storeBuyer',
            'warehouseSeller',
            'storeSeller',
            'rider',
            'riderRequest',
            'shippingAddress'
        ])->findOrFail($id);

        return view('admin.orders.show', compact('order'));
    }
}