<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\QuantityUnit;
use App\Models\State;
use App\Models\District;
use App\Models\Bank;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\Brand;

class DropdownController extends Controller
{
    public function states()
    {
        return response()->json(State::all());
    }

    public function districts($state_id)
    {
        $districts = District::where('state_id', $state_id)->get();
        return response()->json($districts);
    }

    public function banks()
    {
        $banks = Bank::select('id', 'name')
                    ->orderBy('id', 'ASC')
                    ->get();

        return response()->json($banks);
    }

    public function categories()
    {
        return response()->json([
            'success' => true,
            'data' => Category::where('status', 'active')
                ->select('id', 'name')
                ->orderBy('name')
                ->get()
        ]);
    }


    public function subcategories($category_id)
    {
        return response()->json([
            'success' => true,
            'data' => Subcategory::where('category_id', $category_id)
                ->where('status', 'active')
                ->select('id', 'name')
                ->orderBy('name')
                ->get()
        ]);
    }

    public function quantityUnits($category_id)
    {
        return response()->json([
            'success' => true,
            'data' => QuantityUnit::whereJsonContains(
                    'category_ids',
                    (string) $category_id
                )
                ->where('status', 'active')
                ->select('id', 'name')
                ->orderBy('name')
                ->get()
        ]);
    }

    public function brands($category_id)
    {
        return response()->json([
            'success' => true,
            'data' => Brand::whereJsonContains(
                    'category_ids',
                    (string) $category_id   // SAME AS QuantityUnit
                )
                ->where('status', 'active')
                ->select('id', 'name')
                ->orderBy('name')
                ->get()
        ]);
    }



    public function materialTypes()
    {
        return response()->json([
            'success' => true,
            'data' => [
                'Construction Material',
                'Electrical Material',
                'Plumbing Material',
                'Hardware Material'
            ]
        ]);
    }

    public function businessTypes()
    {
        return response()->json([
            'success' => true,
            'data' => [
                'Individual',
                'Proprietorship',
                'Partnership',
                'Private Limited'
            ]
        ]);
    }

    public function businessStatuses()
    {
        return response()->json(
            
            [
            'success' => true,
            'data' => [
                'registered',
                'unregistered'
            ]
        ]);
    }

    public function units()
    {
        return response()->json([
            'success' => true,
            'data' => [
                'Kg',
                'Ton',
                'Bag',
                'Cubic Meter',
                'Piece'
            ]
        ]);
    }




}
