<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    protected $fillable = [
        'user_type', 'user_id', 'name', 'mobile_number',
        'door_no', 'street_name', 'area', 'city', 
        'district_id', 'state_id', 'pincode', 'is_default',
        'latitude','longitude'
    ];

    public function user()
    {
        return $this->morphTo(__FUNCTION__, 'user_type', 'user_id');
    }

    
    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

}
