<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeliveryPrice extends Model
{
    use HasFactory;

    protected $table = 'delivery_prices';

    protected $fillable = [
        'store_delivery_price',
        'customer_delivery_price',
        'is_default',
        'created_by',
        'created_by_type',
    ];

    protected $casts = [
        'is_default' => 'boolean',
        'store_delivery_price' => 'decimal:2',
        'customer_delivery_price' => 'decimal:2',
    ];

    public function scopeDefault($query)
    {
        return $query->where('is_default', true);
    }

    public function creator()
    {
        return $this->morphTo(
            null,
            'created_by_type',
            'created_by'
        );
    }
}
