<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FcmToken extends Model
{
    use HasFactory;

    protected $table = 'fcm_tokens';

    protected $primaryKey = 'id';

    public $timestamps = true;

    protected $fillable = [
        'user_type',
        'user_id',
        'fcm_token',
        'notify_status',
        'device_type',
    ];

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
    ];
    public function user()
    {
        return match ($this->user_type) {
            'warehouse' => $this->belongsTo(Warehouse::class, 'user_id'),
            'store'     => $this->belongsTo(Store::class, 'user_id'),
            'rider'     => $this->belongsTo(Rider::class, 'user_id'),
            'customer'  => $this->belongsTo(Customer::class, 'user_id'),
            default     => null,
        };
    }
}
