<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderItem extends Model
{
    use HasFactory;

    protected $table = 'order_items';

    protected $fillable = [
        'order_id',
        'product_id',
        'quantity',

        'original_unit_price',
        'discounted_unit_price',
        'discount_amount',

        'approved_unit_price',
        'unit_price',
        'total_price',
        'status'
    ];

    protected $casts = [
        'quantity' => 'decimal:2',

        'original_unit_price'   => 'decimal:2',
        'discounted_unit_price' => 'decimal:2',
        'discount_amount'       => 'decimal:2',

        'unit_price'  => 'decimal:2',
        'total_price' => 'decimal:2',
    ];


    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
