<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderRiderRequest extends Model
{
    use HasFactory;

    protected $table = 'order_rider_requests';

    protected $fillable = [
        'order_id',
        'rider_id',
        'warehouse_id',
        'store_id',

        'latitude',
        'longitude',
        'distance_km',
        'trip_amount',

        'status',
        'otp',

        'accepted_at',
        'requested_at',
        'responded_at',
    ];

    protected $casts = [
        'accepted_at'  => 'datetime',
        'requested_at' => 'datetime',
        'responded_at' => 'datetime',
    ];

    /**
     * Order relation
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    /**
     * Rider relation
     */
    public function rider()
    {
        return $this->belongsTo(Rider::class, 'rider_id');
    }

    /**
     * Warehouse relation
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class, 'warehouse_id');
    }
}
