<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductReview extends Model
{
    use HasFactory;

    protected $fillable = ['product_id', 'customer_id', 'order_id', 'store_id', 'rating', 'review', 'status'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function store()
    {
        return $this->belongsTo(Store::class);
    }

    // Helper to get the user name (store or customer)
    public function userName()
    {
        if($this->customer) return $this->customer->name;
        if($this->store) return $this->store->store_name;
        return 'Guest';
    }
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

}
