<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RiderLocation extends Model
{
    use HasFactory;

    protected $table = 'rider_locations';

    protected $fillable = [
        'rider_id',
        'latitude',
        'longitude',
    ];

    /**
     * Relationship: RiderLocation → Rider
     */
    public function rider()
    {
        return $this->belongsTo(Rider::class, 'rider_id');
    }
}
