<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StoreProduct extends Model
{
    protected $fillable = [
        'store_id',
        'product_id',
        'category_id',
        'subcategory_id', 
        'quantity_unit_id',
        'brand_id',
        'price',
        'status',
        'admin_remark',
        'product_active',
        'category_active'
    ];

    public function store()
    {
        return $this->belongsTo(Store::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function subcategory()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory_id');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }
    public function quantityUnit()
    {
        return $this->belongsTo(QuantityUnit::class, 'quantity_unit_id');
    }
}
