<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Laravel\Sanctum\HasApiTokens;


class Warehouse extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'firebase_uid',
        'owner_name',
        'email',
        'mobile_number',
        'password',
        'warehouse_name', 
        'door_no',
        'street_name',
        'area',
        'city',
        'district_id',
        'state_id',
        'pincode',
        'country',
        'gst_number',
        'pan_number',
        'aadhar_number',
        'business_type',
        'business_status',  
        'trade_license_number',
        'bank_id',
        'bank_holder_name',
        'bank_account_number',
        'passbook_file',
        'pending_bank_data',
        'ifsc_code',
        'micr_no',
        'upi_id',
        'bank_status',
        'bank_approved_at', 
        'bank_approved_by',
        'edit_bank',
        'bank_edit_reason',
        'logo',
        'status',
        'admin_remark',
        'approved_at',
        'approved_by',
        'otp',
        'otp_created_at',
        'latitude',
        'longitude',
        'registration_paid',
        'registration_payment_id'
    ];


    protected $hidden = [
        'password',
        'otp'
    ];

    protected $casts = [
        'pending_bank_data' => 'array',
    ];

    public function products()
    {
        return $this->hasMany(WarehouseProduct::class);
    }


    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
    
    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function fcmTokens()
    {
        return $this->hasMany(FcmToken::class, 'user_id')
            ->where('user_type', 'warehouse');
    }

}
