<?php

namespace App\Services;

use Kreait\Firebase\Factory;

class FirebaseService
{
    protected $auth;

    public function __construct()
    {
        $factory = (new Factory)
            ->withServiceAccount(storage_path('app/firebase.json')); // your service account
        $this->auth = $factory->createAuth();
    }

    // Create a custom token for the app (optional)
    public function createCustomToken($uid)
    {
        $customToken = $this->auth->createCustomToken($uid);
        return $customToken->toString();
    }

    // Verify ID token sent from the client after OTP verification
    public function verifyIdToken($idToken)
    {
        return $this->auth->verifyIdToken($idToken);
    }
}
