<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class GeoService
{
    public static function getLatLongFromAddress(string $address): array
    {
        if (empty($address)) {
            return [
                'latitude' => null,
                'longitude' => null
            ];
        }

        $response = Http::get('https://maps.googleapis.com/maps/api/geocode/json', [
            'address' => $address,
            'key' => config('services.google.maps_key')
        ]);

        if ($response->successful() && isset($response['results'][0])) {
            return [
                'latitude' => $response['results'][0]['geometry']['location']['lat'],
                'longitude' => $response['results'][0]['geometry']['location']['lng']
            ];
        }

        return [
            'latitude' => null,
            'longitude' => null
        ];
    }
}
