<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('stores', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->string('email')->unique();
            $table->string('mobile_number')->unique();
            $table->string('password');

            $table->string('door_no');
            $table->string('street_name');
            $table->string('area');
            $table->string('city');
            $table->string('district');
            $table->string('state');
            $table->string('pincode');
            $table->string('country')->default('India');

            $table->string('gst_number')->nullable();
            $table->string('pan_number');

            $table->string('bank_name');
            $table->string('bank_account_number');
            $table->string('ifsc_code');

            $table->string('store_type')->nullable();

            $table->enum('status', ['pending','active','blocked'])->default('pending');

            $table->string('otp', 4)->nullable();
            $table->timestamp('otp_created_at')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stores');
    }
};
