<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BankBranchesSeeder extends Seeder
{
    public function run()
    {
        $folder = storage_path('app/by-bank');
        $files = glob($folder.'/*.json');

        foreach ($files as $file) {
            $json = file_get_contents($file);
            $data = json_decode($json, true);

            foreach ($data as $ifsc => $details) {

                if (empty($details['BANK']) || empty($details['BRANCH']) || empty($details['IFSC'])) {
                    continue;
                }

                DB::table('bank_branches')->updateOrInsert(
                    ['ifsc' => $details['IFSC']],
                    [
                        'bank' => $details['BANK'],
                        'branch' => $details['BRANCH'],
                        'micr' => $details['MICR'] ?? null,
                        'address' => $details['ADDRESS'] ?? null,
                        'state' => $details['STATE'] ?? null,
                        'city' => $details['CITY'] ?? null,
                        'district' => $details['DISTRICT'] ?? null,
                        'centre' => $details['CENTRE'] ?? null,
                        'contact' => $details['CONTACT'] ?? null,
                        'upi' => $details['UPI'] ?? false,
                        'rtgs' => $details['RTGS'] ?? false,
                        'neft' => $details['NEFT'] ?? false,
                        'imps' => $details['IMPS'] ?? false,
                        'swift' => $details['SWIFT'] ?? null,
                        'iso3166' => $details['ISO3166'] ?? null,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]
                );
            }
        }
    }
}
