<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BanksTableSeeder extends Seeder
{
    public function run(): void
    {
        $banks = [
            "State Bank of India",
            "Bank of Baroda",
            "Bank of India",
            "Canara Bank",
            "Central Bank of India",
            "Punjab National Bank",
            "Union Bank of India",
            "Indian Bank",
            "Indian Overseas Bank",
            "UCO Bank",
            "Punjab & Sind Bank",
            "Bank of Maharashtra",
            "HDFC Bank Ltd.",
            "ICICI Bank Ltd.",
            "Axis Bank Ltd.",
            "Kotak Mahindra Bank Ltd.",
            "IndusInd Bank Ltd.",
            "IDFC FIRST Bank Ltd.",
            "Yes Bank Ltd.",
            "RBL Bank Ltd.",
            "Federal Bank Ltd.",
            "South Indian Bank Ltd.",
            "City Union Bank Ltd.",
            "Karur Vysya Bank Ltd.",
            "Tamilnad Mercantile Bank Ltd.",
            "Tamil Nadu Grama Bank",
            "Equitas Small Finance Bank",
            "AU Small Finance Bank",
            "Capital Small Finance Bank",
            "ESAF Small Finance Bank",
            "Suryoday Small Finance Bank",
            "Ujjivan Small Finance Bank",
            "Utkarsh Small Finance Bank",
            "Jana Small Finance Bank",
            "Shivalik Small Finance Bank",
            "Unity Small Finance Bank",
            "HSBC Bank",
            "Deutsche Bank",
            "Standard Chartered Bank",
            "DBS Bank India",
            "Other foreign bank branches",
            "Tamil Nadu State Apex Cooperative Bank",
            "District Central Cooperative Banks",
            "Primary Cooperative Banks",
            "Urban Cooperative Banks",
            "India Post Payments Bank",
            "Airtel Payments Bank",
            "FINO Payments Bank",
            "Jio Payments Bank",
            "Paytm Payments Bank"
        ];

        foreach ($banks as $bank) {
            DB::table('banks')->insert([
                'name' => $bank,
                'created_at' => now(),
                'updated_at' => now()
            ]);
        }
    }
}
