import Echo from 'laravel-echo';
import Pusher from 'pusher-js';

// Use Pusher-compatible Reverb
window.Pusher = Pusher;

const RIDER_ID = 4; // Or dynamically from auth

window.Echo = new Echo({
    broadcaster: 'pusher',
    key: 'lqqq9bmdtm8z12hldcrm', // your Reverb app key
    wsHost: '127.0.0.1',
    wsPort: 8080,
    forceTLS: false,
    disableStats: true,
    enabledTransports: ['ws', 'wss'],
});

window.Echo.channel(`rider-tracking.${RIDER_ID}`)
    .listen('.location.updated', (e) => {
        console.log('📍 Rider Location Update:', e);

        // Example: move a marker on screen
        const marker = document.getElementById('rider-marker');
        if (marker) {
            marker.style.left = `${e.longitude}px`; // replace with map logic
            marker.style.top = `${e.latitude}px`;
        }
    });
