@extends('admin.layouts.app')

@section('title', ' Customer Management')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

@media (max-width: 768px) {
    .dataTables_wrapper {
        overflow-x: auto !important;
        -webkit-overflow-scrolling: touch;
    }

    .table-responsive {
        overflow-x: auto !important;
    }

    table.dataTable {
        min-width: 900px;
    }
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

.dataTables_wrapper {
    overflow: hidden;
}

.table-responsive {
    overflow-x: hidden;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 8px;
    cursor: pointer;
    transition: transform .2s;
}

.action-btn:hover {
    transform: scale(1.2);
}

.action-approve { color: #22c55e; }
.action-reject { color: #ef4444; }

/* ===============================
   DATATABLE CONTROLS
=============================== */
.dataTables_filter input {
    border-radius: 20px;
    padding: 6px 14px;
    border: 1px solid #d1d5db;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   UNIVERSAL ACTION ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    color: #334155;
    cursor: pointer;
    transition: all .2s ease;
    text-decoration: none;
    margin: 0 2px;
}

.icon-btn i {
    font-size: 15px;
}

/* View */
.view-btn {
    color: #0dcaf0;
}
.view-btn:hover {
    background: rgba(13,202,240,.15);
    transform: translateY(-2px);
}

/* Approve */
.approve-btn {
    color: #22c55e;
}
.approve-btn:hover {
    background: rgba(34,197,94,.15);
    transform: translateY(-2px);
}

/* Reject */
.reject-btn {
    color: #ef4444;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}

/* ===============================
   MODALS
=============================== */
.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

.modal-footer .btn {
    border-radius: 20px;
}

.modal-dialog {
    justify-content: center !important;
}
</style>
@endsection

@section('content')
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Customer Management</h3>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-sm">
            ← Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="common-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>#</th>
                            <!-- <th>Profile</th> -->
                            <th>Name</th>
                            <th>Email</th>
                            <th>Mobile</th>
                            <th>Gender</th>
                            <th>Status</th>
                            <th>Orders</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($customers as $customer)
                        <tr>
                            {{-- ID --}}
                            <td>{{ $loop->iteration }}</td>

                            {{-- Profile --}}
                            <!-- <td>
                                <img
                                    src="{{ $customer->profile_image
                                        ? asset('storage/'.$customer->profile_image)
                                        : asset('assets/images/default-user.png') }}"
                                    width="40"
                                    height="40"
                                    class="rounded-circle"
                                    alt="Profile"
                                >
                            </td> -->

                            {{-- Name --}}
                            <td class="fw-semibold text-start">
                                {{ $customer->name }}
                            </td>

                            {{-- Email --}}
                            <td class="text-start">
                                {{ $customer->email ?? 'N/A' }}
                            </td>

                            {{-- Mobile --}}
                            <td>{{ $customer->mobile_number }}</td>

                            {{-- Gender --}}
                            <td class="text-capitalize">
                                {{ $customer->gender ?? 'N/A' }}
                            </td>

                            {{-- Status --}}
                            <td>
                                @if($customer->status === 'active')
                                    <span class="status status-active">Active</span>
                                @elseif($customer->status === 'blocked')
                                    <span class="status status-rejected">Blocked</span>
                                @else
                                    <span class="status status-pending">Pending</span>
                                @endif
                            </td>

                            <td class="text-center">
                                <a href="{{ route('admin.orders.index', ['customer_id' => $customer->id]) }}"
                                class="icon-btn view-btn"
                                title="View Orders">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                </a>
                            </td>


                            {{-- Action --}}
                            <td class="text-center">
                                <a href="{{ route('admin.customers.show', $customer->id) }}"
                                   class="icon-btn view-btn"
                                   title="View Details">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                <button class="icon-btn {{ $customer->status === 'blocked' ? 'approve-btn' : 'reject-btn' }}"
                                    data-id="{{ $customer->id }}"
                                    data-name="{{ $customer->name }}"
                                    data-status="{{ $customer->status }}"
                                    data-bs-toggle="modal"
                                    data-bs-target="#toggleCustomerModal"
                                    title="{{ $customer->status === 'blocked' ? 'Unblock' : 'Block' }}">
                                    <i class="fa-solid {{ $customer->status === 'blocked' ? 'fa-unlock' : 'fa-ban' }}"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="toggleCustomerModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4">

            <div class="modal-header">
                <h5 class="modal-title" id="toggleModalTitle"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <p id="toggleModalMessage" class="mb-0"></p>
                <small class="text-muted" id="toggleModalHint"></small>
            </div>

            <div class="modal-footer">
                <form method="POST" id="toggleCustomerForm">
                    @csrf
                    @method('PATCH')

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Cancel
                    </button>

                    <button type="submit" class="btn" id="toggleConfirmBtn"></button>
                </form>
            </div>

        </div>
    </div>
</div>

@endsection
@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {
    $('#common-table').DataTable({
        pageLength: 10,
        ordering: true,
        order: [[0, 'asc']], // Order by ID ascending
        columnDefs: [
            { orderable: false, targets: [1, 7] } // Profile & Action not sortable
        ]
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    document.querySelectorAll('[data-bs-target="#toggleCustomerModal"]').forEach(btn => {
        btn.addEventListener('click', function () {

            const id     = this.dataset.id;
            const name   = this.dataset.name;
            const status = this.dataset.status;

            const title  = document.getElementById('toggleModalTitle');
            const msg    = document.getElementById('toggleModalMessage');
            const hint   = document.getElementById('toggleModalHint');
            const btnOk  = document.getElementById('toggleConfirmBtn');
            const form   = document.getElementById('toggleCustomerForm');

            if (status === 'blocked') {
                title.innerText = 'Unblock Customer';
                msg.innerHTML   = `Are you sure you want to unblock <strong>${name}</strong>?`;
                hint.innerText  = 'Customer will be able to place orders again.';
                btnOk.className = 'btn btn-success';
                btnOk.innerText = 'Unblock';
                form.action    = `/admin/customers/${id}/unblock`;
            } else {
                title.innerText = 'Block Customer';
                msg.innerHTML   = `Are you sure you want to block <strong>${name}</strong>?`;
                hint.innerText  = 'Blocked customers cannot place orders.';
                btnOk.className = 'btn btn-danger';
                btnOk.innerText = 'Block';
                form.action    = `/admin/customers/${id}/block`;
            }
        });
    });

});
</script>
@endsection

