@extends('admin.layouts.app')

@section('title', ' Customer Details')

@section('styles')
<style>
/* ===============================
   DETAIL PAGE STYLING
=============================== */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
}
.card-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
    font-weight: 600;
    font-size: 1.1rem;
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
}
.detail-row {
    margin-bottom: 1rem;
}
.detail-label {
    font-weight: 600;
    color: #374151;
}
.detail-value {
    color: #111827;
}
.status-badge {
    padding: 6px 16px;
    border-radius: 30px;
    font-weight: 600;
    font-size: 0.9rem;
}
.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

.btn-back {
    background: #f0f4f8;
    color: #10171d;
    font-weight: 500;
    border-radius: 8px;
}
.action-btn {
    padding: 10px 24px;
    border-radius: 8px;
    font-weight: 600;
    margin-right: 12px;
    border: none;
}
.action-approve { background: #22c55e; color: #fff; }
.action-reject { background: #ef4444; color: #fff; }
.modal-header {
    background: linear-gradient(to bottom, #29B2F6, #5AF399);
    color: #fff;
}

.modal-dialog {
    margin-left: auto !important;
    margin-right: auto !important;
    justify-content: center !important;
}

.modal {
    padding-right: 0 !important;
}

th{
    text-align: center;
}


</style>
@endsection

@section('content')
<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Customer Details</h3>
        <a href="{{ route('admin.customers.index') }}" class="btn btn-outline-secondary btn-sm">
            ← Back to Customers
        </a>
    </div>


    <!-- Customer Addresses -->
    <div class="card mb-4">
        <div class="card-header">
            Address Details
        </div>

        <div class="card-body">

            @if($addresses->isEmpty())
                <p class="text-muted mb-0">No address added by customer.</p>
            @else
                @foreach($addresses as $address)
                    <div class="border rounded p-3 mb-3
                        {{ $address->is_default ? 'border-success bg-light' : '' }}">

                        <div class="d-flex justify-content-between mb-2">
                            <strong>
                                {{ $address->name }}
                            </strong>

                            @if($address->is_default)
                                <span class="badge bg-success">Default</span>
                            @endif
                        </div>

                        <p class="mb-1">
                            {{ $address->door_no }},
                            {{ $address->street_name }},
                            {{ $address->area }},
                            {{ $address->city }}
                        </p>

                        <p class="mb-1">
                            {{ $address->district->name ?? 'N/A' }},
                            {{ $address->state->name ?? 'N/A' }} -
                            {{ $address->pincode }}
                        </p>

                        <p class="mb-0 text-muted">
                            Mobile: {{ $address->mobile_number }}
                        </p>
                    </div>
                @endforeach
            @endif

        </div>
    </div>
</div>
@endsection

