@extends('admin.layouts.app')

@section('title', 'Product Reviews')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    /* transform: scale(1.01); */
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

/* ===============================
   SCROLLABLE TABLE
=============================== */
.table-responsive {
    overflow-x: auto !important;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 6px;
    cursor: pointer;
}
.action-edit { color: #f59e0b; }

/* ===========================
   MODAL DESIGN
=========================== */

/* ===========================
   MODAL PERFECT ALIGNMENT
=========================== */

/* Ensure modal-dialog centers properly */
.modal-dialog {
    max-width: 500px; /* responsive max width */
    width: 90%;
    justify-content: center !important;
}

/* Modal content style */
.modal-content {
    border-radius: 1rem;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

/* Modal header */
.modal-header {
    padding: 1rem 1.5rem;
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

/* Modal body with scroll if content is tall */
.modal-body {
    max-height: 60vh;
    overflow-y: auto;
    padding: 1.5rem;
}

/* Inputs styling */
.modal-body .form-control,
.modal-body .form-select {
    box-shadow: none;
    border: 1px solid #ced4da;
    transition: 0.2s;
}

.modal-body .form-control:focus,
.modal-body .form-select:focus {
    border-color: #29b2f6;
    box-shadow: 0 0 5px rgba(41,178,246,0.3);
    outline: none;
}

/* Modal footer */
.modal-footer {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 1.5rem;
    border-top: none;
    background: #f9f9f9;
}

/* Buttons hover effect */
.modal-footer .btn:hover {
    transform: translateY(-2px);
    transition: 0.2s;
}

/* Scrollbar inside modal */
.modal-body::-webkit-scrollbar {
    width: 6px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: rgba(41,178,246,0.5);
    border-radius: 10px;
}

.modal-body::-webkit-scrollbar-track {
    background: transparent;
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}

/* ===============================
   MODERN ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    cursor: pointer;
    transition: all 0.2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* Edit */
.edit-btn {
    color: #0d6efd;
}
.edit-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* Delete */
.delete-btn {
    color: #dc3545;
}
.delete-btn:hover {
    background: rgba(220,53,69,.15);
    transform: translateY(-2px);
}

.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
    text-decoration: none;
}
.btn-back {
    background: #f1f5f9;
    color: #374151;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: 1px solid;
    transition: all .2s ease;
    text-decoration: none;
}

.btn-back:hover {
    background: #e2e8f0;
}

/* ===============================
   SOLD BY DESIGN
=============================== */
.soldby-box{
    padding: 6px 10px;
    border-radius: 10px;
    transition: all .2s ease;
}

.soldby-box:hover{
    background: #f1f7ff;
    transform: translateY(-1px);
}

.soldby-name{
    font-size: 14px;
    font-weight: 600;
    line-height: 1.2;
}

.soldby-type{
    font-size: 11px;
    font-weight: 600;
    padding: 2px 10px;
    border-radius: 20px;
    margin-top: 4px;
    width: fit-content;
    text-transform: uppercase;
    letter-spacing: .04em;
}

/* Type colors */
.soldby-type.warehouse{
    background: #eef2ff;
    color: #4338ca;
}

.soldby-type.store{
    background: #ecfdf5;
    color: #047857;
}


.soldby-type.na{
    background: #fef2f2;
    color: #b91c1c;
}
/* ===============================
   REVIEWED BY DESIGN
=============================== */
.reviewed-box{
    display: flex;
    flex-direction: column;
    align-items: center;
}

.reviewed-badge{
    font-size: 11px;
    font-weight: 600;
    padding: 4px 12px;
    border-radius: 20px;
    text-transform: uppercase;
    letter-spacing: .04em;
}

.reviewed-badge.customer{
    background: #e0f2fe;
    color: #0369a1;
}

.reviewed-badge.store{
    background: #ecfdf5;
    color: #047857;
}

.reviewed-badge.unknown{
    background: #f3f4f6;
    color: #6b7280;
}

.reviewed-name{
    font-size: 13px;
    font-weight: 600;
    margin-top: 6px;
    color: #374151;
}

.product-img{
    width:50px !important;
    height:50px !important;
    border-radius:12px;
    object-fit:cover;
    box-shadow: 0 2px 8px rgba(0,0,0,0.12);
}



</style>
@endsection

@section('content')
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Product Reviews</h3>

        <div class="d-flex gap-2">
            <a href="{{ route('admin.dashboard') }}"
               class="btn-back d-flex align-items-center">
                <i class="fa fa-arrow-left me-2"></i> Dashboard
            </a>
        </div>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="common-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product</th>
                            <th>Order No</th>
                            <th>Sold By</th>
                            <th>Reviewed By</th>
                            <th>Rating</th>
                            <th>Review</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($reviews as $review)
                        <tr>
                            <td>{{ $loop->iteration }}</td>

                            {{-- Product --}}
                            <td class="text-center">
                                <div class="d-flex flex-column align-items-center gap-1">

                                    {{-- Product Image --}}
                                    <img src="{{ $review->product->image 
                                            ? asset($review->product->image) 
                                            : asset('images/no-image.png') }}"
                                        alt="Product" width="50" height="50"
                                        class="rounded-3 object-fit-cover border shadow-sm">

                                    {{-- Category Name --}}
                                    <span class="fw-semibold text-dark small text-center">
                                        {{ $review->product->category ?? '-' }}
                                    </span>

                                </div>
                            </td>

                            {{-- Order No --}}
                            <td>
                                <span class="badge bg-dark">
                                    {{ $review->order->order_no ?? 'N/A' }}
                                </span>
                            </td>

                            {{-- Sold By (Warehouse / Store) --}}
                            <td>
                                @if($review->order && $review->order->approved_by && $review->order->approved_by_user_type)

                                    @php
                                        $type = $review->order->approved_by_user_type; // warehouse | store
                                        $id   = $review->order->approved_by;
                                    @endphp

                                    @if($type === 'warehouse')
                                        @php
                                            $warehouse = \App\Models\Warehouse::find($id);
                                        @endphp

                                        <a href="{{ route('admin.users.show', ['type' => 'warehouse', 'id' => $id]) }}"
                                        class="text-decoration-none d-flex flex-column align-items-center soldby-box">

                                            <div class="fw-semibold text-dark soldby-name">
                                                {{ $warehouse->warehouse_name ?? 'Warehouse' }}
                                            </div>

                                            <div class="soldby-type warehouse">
                                                warehouse
                                            </div>
                                        </a>

                                    @elseif($type === 'store')
                                        @php
                                            $store = \App\Models\Store::find($id);
                                        @endphp

                                        <a href="{{ route('admin.users.show', ['type' => 'store', 'id' => $id]) }}"
                                        class="text-decoration-none d-flex flex-column align-items-center soldby-box">

                                            <div class="fw-semibold text-dark soldby-name">
                                                {{ $store->store_name ?? 'Store' }}
                                            </div>

                                            <div class="soldby-type store">
                                                store
                                            </div>
                                        </a>
                                    @endif

                                @else
                                    <div class="fw-semibold text-dark">N/A</div>
                                @endif
                            </td>

                            {{-- Reviewed By --}}
                            <td>
                                <div class="reviewed-box">

                                    @if($review->customer)
                                        <div class="reviewed-name">
                                            {{ $review->userName() }}
                                        </div>
                                        <div class="reviewed-badge customer">Customer</div>

                                    @elseif($review->store)
                                        <div class="reviewed-name">
                                            {{ $review->userName() }}
                                        </div>
                                        <div class="reviewed-badge store">Store</div>

                                    @else
                                        <div class="reviewed-badge unknown">Unknown</div>
                                        <div class="reviewed-name text-muted">N/A</div>
                                    @endif

                                </div>
                            </td>


                            {{-- Rating --}}
                            <td>
                                <div class="fw-semibold text-warning">
                                    ⭐ {{ $review->rating }}/5
                                </div>
                            </td>

                            {{-- Review --}}
                            <td style="max-width: 300px; text-align:left;">
                                <small class="text-muted">
                                    {{ \Illuminate\Support\Str::limit($review->review, 120) }}
                                </small>
                            </td>

                            {{-- Status --}}
                            <td>
                                <span class="status status-{{ $review->status }}">
                                    {{ ucfirst($review->status) }}
                                </span>
                            </td>

                            {{-- Action --}}
                            <td class="text-center">

                                {{-- TOGGLE STATUS --}}
                                <form method="POST" 
                                      action="{{ route('admin.product-reviews.toggle', $review->id) }}" 
                                      style="display:inline-block">
                                    @csrf
                                    <button class="icon-btn edit-btn"
                                            title="{{ $review->status == 'active' ? 'Deactivate' : 'Activate' }}">
                                        @if($review->status == 'active')
                                            <i class="fa-solid fa-eye-slash"></i>
                                        @else
                                            <i class="fa-solid fa-eye"></i>
                                        @endif
                                    </button>
                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#common-table').DataTable({
        pageLength: 10,
        columnDefs: [
            { orderable: false, targets: [8] } // Action column
        ]
    });

});
</script>
@endsection
