@extends('admin.layouts.app')

@section('title', 'Sub-Category Management')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #fff !important;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    text-align: center;
    font-size: 14px;
    border-top: 1px solid #eef2f6;
}

table.dataTable tbody tr:nth-child(odd) {
    background: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background: #fff;
}

table.dataTable tbody tr {
    transition: all .25s ease;
}
table.dataTable tbody tr:hover {
    background: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   ICON ACTION BUTTONS (FIXED)
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    background: #f1f5f9;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all .2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* EDIT */
.approve-btn {
    color: #0d6efd !important;
}
.approve-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* DELETE */
.reject-btn {
    color: #ef4444 !important;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}


/* ===============================
   ADD BUTTON
=============================== */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
}

/* ===============================
   MODAL FIX (CENTERED & CLEAN)
=============================== */
.modal {
    overflow-y: auto;
    padding-right: 0 !important;
}

.modal-dialog.modal-wide {
    max-width: 900px;   /* change as you want */
    width: 90%;
}


.modal-dialog {
    margin: auto !important;
    max-width: 500px !important;
    justify-content: center !important;
}

.modal-content {
    border-radius: 14px;
    border: none;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
}

.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-top-left-radius: 14px;
    border-top-right-radius: 14px;
}

.modal-footer .btn {
    border-radius: 20px;
}

/* ===============================
   INPUTS
=============================== */
.form-control {
    border-radius: 10px;
}

/* ===============================
   MOBILE FIX
=============================== */
@media (max-width: 768px) {
    .table-responsive {
        overflow-x: auto;
    }
    table.dataTable {
        min-width: 700px;
    }
}

.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }
</style>
@endsection



@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Quantity Unit Management</h3>
        <button class="btn-add" data-bs-toggle="modal" data-bs-target="#addQuantityUnitModal">
            <i class="fa fa-plus me-2"></i> Add Quantity Unit
        </button>
    </div>

    {{-- TABLE --}}
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="quantity-unit-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>S.no</th>
                            <th>Quantity Unit</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($quantityUnits as $unit)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td class="fw-semibold">{{ $unit->name }}</td>
                            <td>
                                @if($unit->category_ids)
                                    @foreach($unit->category_ids as $catId)
                                        {{ $categories->firstWhere('id', $catId)->name ?? 'Unknown' }}@if(!$loop->last), @endif
                                    @endforeach
                                @endif
                            </td>

                            <td>
                                <span class="status status-{{ $unit->status }}">
                                    {{ ucfirst($unit->status) }}
                                </span>
                            </td>
                            <td>
                                <button class="icon-btn approve-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editQuantityUnitModal"
                                        data-id="{{ $unit->id }}"
                                        data-name="{{ $unit->name }}"
                                        data-status="{{ $unit->status }}"
                                        data-categories="{{ json_encode($unit->category_ids) }}">
                                    <i class="fa fa-pen"></i>
                                </button>

                                <button class="icon-btn reject-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteQuantityUnitModal"
                                        data-id="{{ $unit->id }}"
                                        data-name="{{ $unit->name }}">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>

{{-- ADD QUANTITY UNIT MODAL --}}
<div class="modal fade" id="addQuantityUnitModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-wide">
        <form method="POST" action="{{ route('admin.quantity-units.store') }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Quantity Unit</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <label class="detail-label mb-1">Quantity Unit</label>
                    <input type="text" name="name" class="form-control" placeholder="Eg: Kg, Bag, Ton" required>

                    <label class="detail-label mb-1 mt-3">Categories</label>
                    <div id="addQuantityUnitCategories" class="mb-2">
                        @foreach($categories as $cat)
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" 
                                       name="category_ids[]" value="{{ $cat->id }}" 
                                       id="addCategory{{ $cat->id }}">
                                <label class="form-check-label" for="addCategory{{ $cat->id }}">
                                    {{ $cat->name }}
                                </label>
                            </div>
                        @endforeach
                    </div>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Save</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


{{-- EDIT QUANTITY UNIT MODAL --}}
<div class="modal fade" id="editQuantityUnitModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editQuantityUnitForm">
            @csrf
            @method('PUT')

            <div class="modal-content">
                <div class="modal-header">
                    <h5>Edit Quantity Unit</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <label class="detail-label mb-1">Quantity Unit</label>
                    <input type="text" name="name" id="editQuantityUnitName" class="form-control" required>

                    <label class="detail-label mb-1 mt-3">Categories</label>
                    <div id="editQuantityUnitCategories" class="mb-2">
                        @foreach($categories as $cat)
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" 
                                       name="category_ids[]" value="{{ $cat->id }}" 
                                       id="editCategory{{ $cat->id }}">
                                <label class="form-check-label" for="editCategory{{ $cat->id }}">
                                    {{ $cat->name }}
                                </label>
                            </div>
                        @endforeach
                    </div>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" id="editQuantityUnitStatus" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>

                    <span id="quantityStatusPreview" class="status mt-2 d-inline-block"></span>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Update</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>


{{-- DELETE QUANTITY UNIT MODAL --}}
<div class="modal fade" id="deleteQuantityUnitModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteQuantityUnitForm">
            @csrf
            @method('DELETE')

            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5>Confirm Delete</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    Are you sure you want to delete <strong id="deleteQuantityUnitName"></strong>?
                </div>

                <div class="modal-footer">
                    <button class="btn btn-danger px-4">Delete</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script>
$(function () {

    $('#quantity-unit-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: 4 }]
    });

    $('#editQuantityUnitModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        let categories = btn.data('categories'); // JSON array of category IDs
        $('#editQuantityUnitName').val(btn.data('name'));
        $('#editQuantityUnitStatus').val(btn.data('status'));

        // Uncheck all first
        $('#editQuantityUnitCategories input[type="checkbox"]').prop('checked', false);

        // Check the categories that belong to this quantity unit
        categories.forEach(function(catId){
            $('#editCategory' + catId).prop('checked', true);
        });

        $('#quantityStatusPreview')
            .attr('class', 'status status-' + btn.data('status'))
            .text(btn.data('status').charAt(0).toUpperCase() + btn.data('status').slice(1));

        $('#editQuantityUnitForm').attr(
            'action',
            "{{ route('admin.quantity-units.update', ':id') }}".replace(':id', btn.data('id'))
        );
    });



    // Status preview
    $('#editQuantityUnitStatus').on('change', function(){
        let val = $(this).val();
        $('#quantityStatusPreview')
            .attr('class', 'status status-' + val)
            .text(val.charAt(0).toUpperCase() + val.slice(1));
    });

    // Delete Quantity Unit
    $('#deleteQuantityUnitModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        $('#deleteQuantityUnitName').text(btn.data('name'));
        $('#deleteQuantityUnitForm').attr(
            'action',
            "{{ route('admin.quantity-units.destroy', ':id') }}".replace(':id', btn.data('id'))
        );
    });

});
</script>
@endsection
