@extends('admin.layouts.app')

@section('title', ' Rider Management')

@section('styles')
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

@media (max-width: 768px) {
    .dataTables_wrapper {
        overflow-x: auto !important;
        -webkit-overflow-scrolling: touch;
    }

    .table-responsive {
        overflow-x: auto !important;
    }

    table.dataTable {
        min-width: 900px;
    }
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

.dataTables_wrapper {
    overflow: hidden;
}

.table-responsive {
    overflow-x: hidden;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-pending { background: #fff5e5; color: #d48806; }
.status-rejected { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 8px;
    cursor: pointer;
    transition: transform .2s;
}

.action-btn:hover {
    transform: scale(1.2);
}

.action-approve { color: #22c55e; }
.action-reject { color: #ef4444; }

/* ===============================
   DATATABLE CONTROLS
=============================== */
.dataTables_filter input {
    border-radius: 20px;
    padding: 6px 14px;
    border: 1px solid #d1d5db;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   UNIVERSAL ACTION ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    color: #334155;
    cursor: pointer;
    transition: all .2s ease;
    text-decoration: none;
    margin: 0 2px;
}

.icon-btn i {
    font-size: 15px;
}

/* View */
.view-btn {
    color: #0dcaf0;
}
.view-btn:hover {
    background: rgba(13,202,240,.15);
    transform: translateY(-2px);
}

/* Approve */
.approve-btn {
    color: #22c55e;
}
.approve-btn:hover {
    background: rgba(34,197,94,.15);
    transform: translateY(-2px);
}

/* Reject */
.reject-btn {
    color: #ef4444;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}

/* ===============================
   MODALS
=============================== */
.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

.modal-footer .btn {
    border-radius: 20px;
}

.modal-dialog {
    justify-content: center !important;
}
</style>
@endsection

@section('content')
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Rider Management</h3>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-sm">
            ← Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="common-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Rider Name</th>
                            <th>Rider Code</th>
                            <th>Mobile</th>
                            <th>Vehicle</th>
                            <th>City</th>
                            <th>Rate Info</th>
                            <th>Status</th>
                            <th>Availability</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($riders as $rider)
                        <tr>
                            <td class="text-center">
                                {{ $loop->iteration }}
                            </td>

                            <td style="text-align:left" class="fw-semibold">
                                {{ $rider->name }}
                            </td>

                            <td style="text-align:center" class="fw-semibold">
                                {{ $rider->rider_code ?? 'N/A' }}
                            </td>

                            <td>{{ $rider->mobile_number }}</td>

                            <td>
                                {{ $rider->vehicle_type }} <br>
                                <small class="text-muted">{{ $rider->vehicle_number }}</small>
                            </td>

                            <td>{{ $rider->city }}</td>

                            <td>
                                <div class="fw-semibold">
                                    ₹{{ number_format($rider->ratePerKm ?? 0, 2) }} / km
                                </div>
                                <small class="text-muted">
                                    Range: {{ $rider->range ?? 'N/A' }} km
                                </small>

                                <div class="mt-1">
                                    <span class="badge
                                        {{ $rider->rate_change_status === 'approved' ? 'bg-success' :
                                        ($rider->rate_change_status === 'pending' ? 'bg-warning' : 'bg-danger') }}">
                                        {{ ucfirst($rider->rate_change_status) }}
                                    </span>
                                </div>
                            </td>

                            <td>
                                @if($rider->status === 'active')
                                    <span class="status status-active">Active</span>
                                @elseif($rider->status === 'pending_admin')
                                    <span class="status status-pending">Pending</span>
                                @elseif($rider->status === 'blocked')
                                    <span class="status status-rejected">Blocked</span>
                                @else
                                    <span class="status status-rejected">Rejected</span>
                                @endif
                            </td>

                            <td>
                                @if($rider->is_available)
                                    <span class="badge bg-success">Available</span>
                                @else
                                    <span class="badge bg-secondary">Not Available</span>
                                @endif
                            </td>


                            <td class="text-center">
                                <a href="{{ route('admin.riders.show', $rider->id) }}"
                                   class="icon-btn view-btn"
                                   title="View Details">
                                    <i class="fa-solid fa-eye"></i>
                                </a>

                                @if($rider->status === 'pending_admin')
                                    <button class="icon-btn approve-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#approveModal"
                                            data-id="{{ $rider->id }}"
                                            title="Approve">
                                        <i class="fa-solid fa-check"></i>
                                    </button>

                                    <button class="icon-btn reject-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#rejectModal"
                                            data-id="{{ $rider->id }}"
                                            title="Reject">
                                        <i class="fa-solid fa-xmark"></i>
                                    </button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>

</div>

{{-- APPROVE MODAL --}}
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="approveForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Rider</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to approve this rider?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success px-4">Approve</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- REJECT MODAL --}}
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="rejectForm">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Rider</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <p>Are you sure you want to reject this rider?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger px-4">Reject</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection



@section('scripts')
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#common-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: [0, 7] }], // Make "Action" column not orderable
        ordering: true,
        order: [],
    });

    // Approve modal
    $('#approveModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "{{ route('admin.riders.approve', ':id') }}";
        $('#approveForm').attr('action', url.replace(':id', id));
    });

    // Reject modal
    $('#rejectModal').on('show.bs.modal', function (e) {
        let id = $(e.relatedTarget).data('id');
        let url = "{{ route('admin.riders.reject', ':id') }}";
        $('#rejectForm').attr('action', url.replace(':id', id));
    });

});
</script>

@endsection

