<!DOCTYPE html>
<html>
<head>
    <title>BuildOurs - Login OTP</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 30px auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background-color: #0d6efd; /* BuildOurs brand color */
            padding: 20px;
            text-align: center;
        }
        .header img {
            height: 40px;
        }
        .content {
            padding: 30px 20px;
            text-align: center;
        }
        .content h2 {
            color: #333333;
        }
        .otp-code {
            font-size: 28px;
            letter-spacing: 4px;
            color: #0d6efd;
            margin: 20px 0;
        }
        .content p {
            color: #555555;
            font-size: 16px;
            line-height: 1.5;
        }
        .footer {
            background-color: #f1f1f1;
            padding: 15px;
            text-align: center;
            font-size: 12px;
            color: #888888;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <img src="{{ asset('assets/images/logo.jpg') }}" alt="BuildOurs Logo">
        </div>
        <div class="content">
            <h2>Hello {{ $customerName ?? '' }},</h2>
            <p>Use the following OTP to login to your BuildOurs account:</p>
            <div class="otp-code">{{ $otp }}</div>
            <p>This OTP is valid for <strong>5 minutes</strong>. Please do not share it with anyone.</p>
        </div>
        <div class="footer">
            &copy; {{ date('Y') }} BuildOurs. All rights reserved.<br>
            If you did not request this OTP, please ignore this email.
        </div>
    </div>
</body>
</html>
