<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>New Order Assigned</title>
</head>
<body style="margin:0; padding:0; background-color:#f4f6f8; font-family:Arial, Helvetica, sans-serif;">

<table width="100%" cellpadding="0" cellspacing="0" style="background-color:#f4f6f8; padding:30px 0;">
    <tr>
        <td align="center">

            <!-- Main Container -->
            <table width="600" cellpadding="0" cellspacing="0" style="background:#ffffff; border-radius:8px; overflow:hidden; box-shadow:0 2px 8px rgba(0,0,0,0.08);">

                <!-- Header -->
                <tr>
                    <td style="background:#0d6efd; padding:20px 30px;">
                        <table width="100%">
                            <tr>
                                <td align="center">
                                    <img src="{{ $message->embed(public_path('assets/images/logo.jpg')) }}"
                                         alt="Buildours"
                                         style="height:80px;">
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <!-- Body -->
                <tr>
                    <td style="padding:30px; color:#333333;">

                        <h2 style="margin-top:0; font-size:22px; color:#111;">
                            New Order Assigned
                        </h2>

                        <p style="font-size:15px; line-height:1.6;">
                            Hello <strong>{{ $receiver->name ?? ucfirst($receiverType) }}</strong>,
                        </p>

                        <p style="font-size:15px; line-height:1.6;">
                            A new order has been successfully assigned to your
                            <strong>{{ ucfirst($receiverType) }}</strong>.
                            Please review the order details and proceed with the next steps.
                        </p>

                        <!-- Order Summary -->
                        <table width="100%" cellpadding="0" cellspacing="0" style="margin:25px 0; border:1px solid #e5e7eb; border-radius:6px;">
                            <tr style="background:#f9fafb;">
                                <td colspan="2" style="padding:12px 15px; font-weight:bold; font-size:14px;">
                                    Order Summary
                                </td>
                            </tr>

                            <tr>
                                <td style="padding:10px 15px; font-size:14px;">Order Number</td>
                                <td style="padding:10px 15px; font-size:14px;"><strong>#{{ $order->order_no }}</strong></td>
                            </tr>

                            <tr style="background:#fafafa;">
                                <td style="padding:10px 15px; font-size:14px;">Invoice Number</td>
                                <td style="padding:10px 15px; font-size:14px;">
                                    {{ $order->invoice_no ?? 'Not Generated' }}
                                </td>
                            </tr>

                            <tr>
                                <td style="padding:10px 15px; font-size:14px;">Order Type</td>
                                <td style="padding:10px 15px; font-size:14px;">
                                    {{ $order->with_shipping ? 'With Shipping' : 'Without Shipping' }}
                                </td>
                            </tr>

                            <tr style="background:#fafafa;">
                                <td style="padding:10px 15px; font-size:14px;">Order Date</td>
                                <td style="padding:10px 15px; font-size:14px;">
                                    {{ \Carbon\Carbon::parse($order->approved_at)->format('d M Y, h:i A') }}
                                </td>
                            </tr>
                        </table>

                        <!-- CTA -->
                        <p style="font-size:15px; line-height:1.6;">
                            Please log in to your dashboard to view full order details and manage fulfillment.
                        </p>

                        <!-- <table cellpadding="0" cellspacing="0" style="margin-top:20px;">
                            <tr>
                                <td style="background:#0d6efd; padding:12px 22px; border-radius:5px;">
                                    <a href="{{ url($receiverType.'/orders') }}"
                                       style="color:#ffffff; font-size:14px; text-decoration:none; font-weight:bold;">
                                        View Order Dashboard
                                    </a>
                                </td>
                            </tr>
                        </table> -->

                        <p style="margin-top:30px; font-size:14px; color:#555;">
                            If you have any questions or notice discrepancies, please contact the support team immediately.
                        </p>

                        <p style="font-size:14px; color:#555;">
                            Thank you for working with <strong>Buildours</strong>.
                        </p>

                        <p style="margin-top:25px; font-size:14px;">
                            Regards,<br>
                            <strong>Buildours Operations Team</strong>
                        </p>

                    </td>
                </tr>

                <!-- Footer -->
                <tr>
                    <td style="background:#f1f3f5; padding:15px 30px; text-align:center; font-size:12px; color:#777;">
                        © {{ date('Y') }} Buildours. All rights reserved.<br>
                        This is an automated message. Please do not reply to this email.
                    </td>
                </tr>

            </table>

        </td>
    </tr>
</table>

</body>
</html>
