<!DOCTYPE html>
<html>
<head>
    <title>Rider Live Location Test</title>

    <!-- Laravel Echo + Pusher (Reverb compatible) -->
    <script src="https://cdn.jsdelivr.net/npm/laravel-echo@1.15.0/dist/echo.iife.js"></script>
    <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>

    <style>
        body {
            font-family: Arial;
            padding: 20px;
        }
        .box {
            border: 1px solid #ccc;
            padding: 15px;
            width: 300px;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<h2>🚴 Rider Live Location (Reverb Test)</h2>

<div class="box">
    <p><b>Rider ID:</b> <span id="riderId">1</span></p>
    <p><b>Latitude:</b> <span id="lat">--</span></p>
    <p><b>Longitude:</b> <span id="lng">--</span></p>
</div>

<script>
    const riderId = 1; // change if needed

    window.Echo = new Echo({
        broadcaster: 'pusher',
        key: 'local',
        wsHost: '127.0.0.1',
        wsPort: 8080,
        forceTLS: false,
        encrypted: false,
        disableStats: true,
    });

    Echo.channel(`rider-location.${riderId}`)
        .listen('.location.updated', (e) => {
            console.log('Live update:', e);

            document.getElementById('lat').innerText = e.latitude;
            document.getElementById('lng').innerText = e.longitude;
        });
</script>

</body>
</html>
