<?php

use App\Events\RiderLocationUpdated;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CustomerOrderController;
use App\Http\Controllers\DropdownController;
use App\Http\Controllers\RiderController;
use App\Http\Controllers\RiderOrderController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\StoreOrderController;
use App\Http\Controllers\StorePurchaseController;
use App\Http\Controllers\WarehouseOrderController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\AdminController;


Route::post('/auth/firebase-login', [App\Http\Controllers\Api\AuthController::class, 'firebaseLogin']);

// =============================
// DROPDOWN APIS (Public for all user types)
// =============================
Route::prefix('dropdowns')->name('dropdowns.')->group(function () {

    Route::get('states', [DropdownController::class, 'states'])->name('states');
    Route::get('districts/{state}', [DropdownController::class, 'districts'])->name('districts');
    Route::get('banks', [DropdownController::class, 'banks'])->name('banks');
    Route::get('categories', [DropdownController::class, 'categories'])->name('categories');
    Route::get('subcategories/{category}', [DropdownController::class, 'subcategories'])->name('subcategories');
    Route::get('quantity-unit/{category}', [DropdownController::class, 'quantityUnits'])->name('quantityUnits');
    Route::get('brands/{category_id}', [DropdownController::class, 'brands'])->name('brands');
    Route::get('material-types', [DropdownController::class, 'materialTypes'])->name('material');
    Route::get('business-types', [DropdownController::class, 'businessTypes'])->name('businessTypes');
    Route::get('business-statuses', [DropdownController::class, 'businessStatuses'])->name('businessStatuses');
    Route::get('units', [DropdownController::class, 'units'])->name('units');

});


Route::prefix('warehouse')->group(function () {
    Route::post('initiateRegistration', [WarehouseController::class, 'initiateRegistration']);
    Route::post('completeRegistration', [WarehouseController::class, 'completeRegistration']);
    Route::post('register', [WarehouseController::class, 'register']);
    Route::post('verify-otp', [WarehouseController::class, 'verifyOtp']);
    Route::post('login', [WarehouseController::class, 'login']);
    Route::post('forgot-password', [WarehouseController::class, 'forgotPassword']);
    Route::post('forgot-password/verify-otp', [WarehouseController::class, 'verifyForgotOtp']);
    Route::post('reset-password', [WarehouseController::class, 'resetPassword']);
    


    Route::middleware('auth:warehouse')->group(function () {
        Route::get('notifications', [WarehouseController::class, 'notifications']);
        Route::get('notification-count', [WarehouseController::class, 'activeNotificationsCount']);
        Route::post('notifications-status/{notificationId}', [WarehouseController::class, 'toggleNotificationStatus']);
        Route::post('change-password', [WarehouseController::class, 'changePassword']);
        Route::get('profile', [WarehouseController::class, 'profile']);
        Route::get('account-details', [WarehouseController::class, 'accountDetails']);
        Route::post('update-logo', [WarehouseController::class, 'updateLogo']);
        Route::get('owner-details', [WarehouseController::class, 'ownerDetails']);
        Route::get('business-details', [WarehouseController::class, 'businessDetails']);
        Route::get('legal-documents', [WarehouseController::class, 'legalDocuments']);
        Route::get('bank-details', [WarehouseController::class, 'bankDetails']);
        Route::post('bank-details', [WarehouseController::class, 'saveBankDetails']);
        Route::post('bank-details/update', [WarehouseController::class, 'updateBankDetails']);
        Route::get('quote-details', [WarehouseController::class, 'quotationDetails']);
        Route::get('category', [WarehouseController::class, 'warehouseCategoryPage']);
        Route::get('category/{category_id}/products',[WarehouseController::class, 'categoryProductsById']);
        Route::get('category/{category_id}/filters',[WarehouseController::class, 'categoryProductFilters']);
        Route::get('product/edit/{id}',[WarehouseController::class, 'getWarehouseProductForEdit']);
        Route::Post('product/update/{id}', [WarehouseController::class, 'updateWarehouseProduct']);
        Route::post('add-products', [WarehouseController::class, 'addProducts']);
        Route::post('category/{category_id}/toggle-active',[WarehouseController::class, 'toggleWarehouseCategoryActive']);
        Route::delete('category/{category_id}',[WarehouseController::class, 'deleteWarehouseCategory']);
        Route::post( 'product/{warehouse_product_id}/toggle-active',[WarehouseController::class, 'toggleWarehouseProductActive']);
        Route::delete('product/{warehouse_product_id}',[WarehouseController::class, 'deleteWarehouseProduct']);  


        Route::get('dashboard',[WarehouseOrderController::class, 'warehouseDashboard']);
        Route::get('nearby-orders',[WarehouseOrderController::class, 'getNearbyStoreOrders']);
        Route::post('orders/{order_id}/approve', [WarehouseOrderController::class, 'approveOrder']);
        Route::post('orders/{order_id}/reject', [WarehouseOrderController::class, 'rejectOrder']);
        Route::get('pending-orders', [WarehouseOrderController::class, 'getPendingOrders']);
        Route::get('orders/{order_id}/available-riders', [WarehouseOrderController::class, 'getAvailableRiders']);
        Route::post('orders/{order_id}/send-rider-requests', [WarehouseOrderController::class, 'sendRiderRequests']);
        Route::get('orders/assigned-orders', [WarehouseOrderController::class, 'getAssignedOrders']);
        Route::get('orders/{order_id}/awaiting-rider', [WarehouseOrderController::class, 'getAwaitingRider']);
        Route::get('orders/assigned-orders/{order_id}', [WarehouseOrderController::class, 'getAssignedOrderDetail']);
        Route::post('orders/verify-rider-and-generate-load-otp', [WarehouseOrderController::class, 'verifyRiderAndGenerateLoadOtp']);
        Route::get('orders/loaded-orders', [WarehouseOrderController::class, 'getLoadedOrders']);
        Route::get('orders/loaded-orders/{order_id}', [WarehouseOrderController::class, 'getLoadedOrderDetail']);
        Route::get('orders/delivered-orders', [WarehouseOrderController::class, 'getDeliveredOrders']);
        Route::get('orders/delivered-orders/{order_id}', [WarehouseOrderController::class, 'getDeliveredOrderDetail']);
        Route::get('sales-report', [WarehouseOrderController::class, 'warehouseSalesReport']);


        Route::post('logout', [WarehouseController::class, 'logout']);
        Route::post('refresh', [WarehouseController::class, 'refresh']);
    });
});


Route::prefix('store')->group(function () {
    Route::post('register', [StoreController::class, 'register']);
    Route::post('verify-otp', [StoreController::class, 'verifyOtp']);
    Route::post('login', [StoreController::class, 'login']);
    Route::post('forgot-password', [StoreController::class, 'forgotPassword']);
    Route::post('forgot-password/verify-otp', [StoreController::class, 'verifyForgotOtp']);
    Route::post('reset-password', [StoreController::class, 'resetPassword']);
    Route::get('razorpay/payment-success', [StorePurchaseController::class, 'razorpayPaymentSuccess'])->name('razorpay.payment.success');
    Route::get('cashfree/payment-success', [StorePurchaseController::class, 'cashfreePaymentSuccess'])->name('api.cashfree.payment-success');
    Route::post('cashfree/payment-webhook', [StorePurchaseController::class, 'cashfreeWebhook'])->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);



    Route::middleware('auth:store')->group(function () {
        Route::get('notifications', [StoreController::class, 'notifications']);
        Route::get('notification-count', [StoreController::class, 'activeNotificationsCount']);
        Route::post('notifications-status/{notificationId}', [StoreController::class, 'toggleNotificationStatus']);
        Route::post('change-password', [StoreController::class, 'changePassword']);
        Route::get('profile', [StoreController::class, 'profile']);
        Route::get('account-details', [StoreController::class, 'accountDetails']);
        Route::post('update-logo', [StoreController::class, 'updateLogo']);
        Route::get('owner-details', [StoreController::class, 'ownerDetails']);
        Route::get('business-details', [StoreController::class, 'businessDetails']);
        Route::get('legal-documents', [StoreController::class, 'legalDocuments']);
        Route::get('bank-details', [StoreController::class, 'bankDetails']);
        Route::post('bank-details', [StoreController::class, 'saveBankDetails']);
        Route::post('bank-details/update', [StoreController::class, 'updateBankDetails']);
        Route::get('quote-details', [StoreController::class, 'quotationDetails']);
        Route::get('category', [StoreController::class, 'storeCategoryPage']);
        Route::get('category-products/{category_id}',[StoreController::class, 'categoryProductsById']);
        Route::get('product/edit/{id}',[StoreController::class, 'getStoreProductForEdit']);
        Route::Post('product/update/{id}', [StoreController::class, 'updateStoreProduct']);
        Route::post('add-products', [StoreController::class, 'addProducts']);
        Route::post('category/{category_id}/toggle-active',[StoreController::class, 'toggleStoreCategoryActive']);
        Route::delete('category/{category_id}',[StoreController::class, 'deleteStoreCategory']);
        Route::post('product/{store_product_id}/toggle-active',[StoreController::class, 'toggleStoreProductActive']);
        Route::delete('product/{store_product_id}',[StoreController::class, 'deleteStoreProduct']);

        // =============================
        // Store sale
        // =============================
        Route::get('sale-dashboard',[StoreOrderController::class, 'storeSalesDashboard']);
        Route::get('nearby-orders',[StoreOrderController::class, 'getNearbyCustomerOrders']);
        Route::post('orders/{order_id}/approve', [StoreOrderController::class, 'approveOrder']);
        Route::post('orders/{order_id}/reject', [StoreOrderController::class, 'rejectOrder']);
        Route::get('pending-orders', [StoreOrderController::class, 'getPendingOrders']);
        Route::get('orders/{order_id}/available-riders', [StoreOrderController::class, 'getAvailableRiders']);
        Route::post('orders/{order_id}/send-rider-requests', [StoreOrderController::class, 'sendRiderRequests']);
        Route::get('orders/assigned-orders', [StoreOrderController::class, 'getAssignedOrders']);
        Route::get('orders/{order_id}/awaiting-rider', [StoreOrderController::class, 'getAwaitingRider']);
        Route::get('orders/assigned-orders/{order_id}', [StoreOrderController::class, 'getAssignedOrderDetail']);
        Route::post('orders/verify-rider-and-generate-load-otp', [StoreOrderController::class, 'verifyRiderAndGenerateLoadOtp']);
        Route::get('orders/loaded-orders', [StoreOrderController::class, 'getLoadedOrders']);
        Route::get('orders/loaded-orders/{order_id}', [StoreOrderController::class, 'getLoadedOrderDetail']);
        Route::get('orders/delivered-orders', [StoreOrderController::class, 'getDeliveredOrders']);
        Route::get('orders/delivered-orders/{order_id}', [StoreOrderController::class, 'getDeliveredOrderDetail']);
        Route::get('sales-report', [StoreOrderController::class, 'storeSalesReport']);

        // =============================
        // Store Purchase
        // =============================
        Route::get('purchase/home',[StorePurchaseController::class, 'purchaseMainPage']);
        Route::get('purchase/home/categories',[StorePurchaseController::class, 'allCategories']);
        Route::get('purchase/filters/{category_id}',[StorePurchaseController::class, 'productFiltersByCategory']);
        Route::get('purchase/categories/{category_id}/products', [StorePurchaseController::class, 'productsByCategory']);
        Route::get('purchase/products/{id}', [StorePurchaseController::class, 'productDetail']);
        Route::get('purchase/products/{id}/reviews', [StorePurchaseController::class, 'allReviews']);

        Route::post('cart/add', [StorePurchaseController::class, 'addToCart']);
        Route::delete('cart/remove/{product_id}', [StorePurchaseController::class, 'removeFromCart']);
        Route::get('cart', [StorePurchaseController::class, 'getCart']);
        Route::post('cart/update-quantity/{cartItemId}', [StorePurchaseController::class, 'updateCartQuantity']);
        Route::post('cart/choose-shipping', [StorePurchaseController::class, 'CartSelection']);
        Route::get('cart/review', [StorePurchaseController::class, 'getCartReview']);
        Route::post('buy-now', [StorePurchaseController::class, 'buyNow']);
        Route::get('buy-now/review/{product_id}', [StorePurchaseController::class, 'buyNowReview']);

        Route::post('address/add', [StorePurchaseController::class, 'addAddress']);
        Route::put('address/edit/{id}', [StorePurchaseController::class, 'editAddress']);

        Route::post('buy-now/rider/verify-temp', [StorePurchaseController::class, 'verifyRiderTemp']);
        Route::post('buy-now/place-order', [StorePurchaseController::class, 'placeOrder']);
        Route::post('buy-now/cart-order', [StorePurchaseController::class, 'CartplaceOrder']);
        
        Route::post('orders/choose-payment', [StorePurchaseController::class, 'PaymentChoose']);
        Route::post('razorpay/create-link', [StorePurchaseController::class, 'createRazorpayPaymentLink']);
        Route::post('cashfree/create-link', [StorePurchaseController::class, 'createCashfreePaymentLink'])->name('api-customer.cashfree.create-link');


        Route::get('my-purchase', [StorePurchaseController::class, 'getMyStoreOrders']);
        Route::get('my-purchase/{order_id}', [StorePurchaseController::class, 'getStoreOrderDetail']);
        Route::post('orders/{order_id}/cancel', [StorePurchaseController::class, 'cancelOrder']);
        Route::post('reviews/submit', [StorePurchaseController::class, 'submitProductReview']);
        Route::get('purchase/invoice/{order_id}', [StorePurchaseController::class, 'getStoreOrderInvoice']);
        Route::get('purchase/orders/{order_id}/invoice/pdf', [StorePurchaseController::class, 'downloadStoreOrderInvoicePdf']);


        Route::get('purchase-report', [StorePurchaseController::class, 'retailPurchaseReport']);
        Route::get('purchase-dashboard', [StorePurchaseController::class, 'storePurchaseDashboard']);


        Route::post('logout', [StoreController::class, 'logout']);
        Route::post('refresh', [StoreController::class, 'refresh']);
    });
});


Route::prefix('customer')->group(function () {

    Route::post('register', [CustomerController::class, 'register']);
    Route::post('login', [CustomerController::class, 'loginOrRegister']);
    Route::post('verify-otp', [CustomerController::class, 'verifyOtp']);
    Route::post('forgot-password', [CustomerController::class, 'forgotPassword']);
    Route::post('forgot-password/verify-otp', [CustomerController::class, 'verifyForgotOtp']);
    Route::post('reset-password', [CustomerController::class, 'resetPassword']);

    Route::get('home-page', [CustomerOrderController::class, 'homePage']);
    Route::get('categories-subcategories', [CustomerOrderController::class, 'categoriesWithSubcategories']);
    Route::get('filter/{subcategory_id}', [CustomerOrderController::class, 'getFiltersBySubcategory']);
    Route::get('subcategory/{subcategory_id}/products', [CustomerOrderController::class, 'productsBySubcategory']);
    Route::get('products/{id}', [CustomerOrderController::class, 'productDetail']);
    Route::get('products/{id}/reviews', [CustomerOrderController::class, 'allReviews']);

    Route::get('razorpay/payment-success', [CustomerOrderController::class, 'razorpayPaymentSuccess'])->name('razorpay-customer.payment.success');
    Route::get('cashfree/payment-success', [CustomerOrderController::class, 'cashfreePaymentSuccess'])->name('api-customer.cashfree.payment-success');
    Route::post('cashfree/payment-webhook', [CustomerOrderController::class, 'cashfreeWebhook'])->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);



    Route::middleware('auth:customer')->group(function () {

        Route::get('notifications', [CustomerController::class, 'notifications']);
        Route::get('notification-count', [CustomerController::class, 'activeNotificationsCount']);
        Route::patch('notifications/{notificationId}/status', [CustomerController::class, 'toggleNotificationStatus']);

        Route::get('account', [CustomerController::class, 'account']);
        Route::get('profile', [CustomerController::class, 'getProfile']);
        Route::put('profile', [CustomerController::class, 'updateProfile']);

        Route::post('addresses', [CustomerController::class, 'addAddress']);
        Route::get('addresses', [CustomerController::class, 'listAddresses']);
        Route::get('addresses/{id}', [CustomerController::class, 'getAddress']);
        Route::put('addresses/{id}', [CustomerController::class, 'updateAddress']);
        Route::post('addresses/{id}/make-default', [CustomerController::class, 'makeAddressDefault']);
        Route::delete('addresses/{id}', [CustomerController::class, 'deleteAddress']);



        Route::post('cart/add', [CustomerOrderController::class, 'addToCart']);
        Route::delete('cart/remove/{product_id}', [CustomerOrderController::class, 'removeFromCart']);
        Route::get('cart', [CustomerOrderController::class, 'getCart']);
        Route::post('cart/update-quantity/{cartItemId}', [CustomerOrderController::class, 'updateCartQuantity']);
        Route::post('buy-now', [CustomerOrderController::class, 'buyNow']);
        Route::get('buy-now/review/{product_id}', [CustomerOrderController::class, 'buyNowReview']);

        Route::post('buy-now/rider/verify-temp', [CustomerOrderController::class, 'verifyRiderTemp']);
        Route::post('buy-now/place-order', [CustomerOrderController::class, 'placeOrder']);
        Route::post('buy-now/cart-order', [CustomerOrderController::class, 'CartplaceOrder']);

        Route::post('orders/choose-payment', [CustomerOrderController::class, 'PaymentChoose']);
        Route::post('razorpay/create-link', [CustomerOrderController::class, 'createRazorpayPaymentLink']);
        Route::post('cashfree/create-link', [CustomerOrderController::class, 'createCashfreePaymentLink'])->name('api.cashfree.create-link');


        Route::get('my-purchase', [CustomerOrderController::class, 'getMyOrders']);
        Route::get('my-purchase/{order_id}', [CustomerOrderController::class, 'getOrderDetail']);
        Route::post('orders/{order_id}/cancel', [CustomerOrderController::class, 'cancelOrder']);
        Route::get('purchase/invoice/{order_id}', [CustomerOrderController::class, 'getOrderInvoice']);
        Route::get('purchase-report', [CustomerOrderController::class, 'retailPurchaseReport']);

        Route::post('reviews/submit', [CustomerOrderController::class, 'submitProductReview']);

        Route::post('logout', [CustomerController::class, 'logout']);
        Route::post('refresh', [CustomerController::class, 'refresh']);
    });
});


Route::prefix('rider')->group(function () {
    Route::post('register', [RiderController::class, 'register']);
    Route::post('verify-otp', [RiderController::class, 'verifyOtp']);
    Route::post('login', [RiderController::class, 'login']);
    Route::post('forgot-password', [RiderController::class, 'forgotPassword']);
    Route::post('forgot-password/verify-otp', [RiderController::class, 'verifyForgotOtp']);
    Route::post('reset-password', [RiderController::class, 'resetPassword']);

    Route::middleware('auth:rider')->group(function () {
        Route::get('home', [RiderOrderController::class, 'riderHome']);
        Route::get('notifications', [RiderController::class, 'notifications']);
        Route::get('notification-count', [RiderController::class, 'activeNotificationsCount']);
        Route::post('notifications-status/{notificationId}', [RiderController::class, 'toggleNotificationStatus']);
        Route::get('profile', [RiderController::class, 'profile']);
        Route::post('logout', [RiderController::class, 'logout']);
        Route::post('change-password', [RiderController::class, 'changePassword']);
        Route::post('refresh', [RiderController::class, 'refresh']);
        Route::get('account-details', [RiderController::class, 'accountDetails']);
        Route::post('update-logo', [RiderController::class, 'updateLogo']);
        Route::get('bank-details', [RiderController::class, 'bankDetails']);
        Route::post('bank-details', [RiderController::class, 'saveBankDetails']);
        Route::post('bank-details/update', [RiderController::class, 'updateBankDetails']);
        Route::get(' e2wqz  qasdt2', [RiderController::class, 'rateDetails']);
        Route::post('rate-update', [RiderController::class, 'updateRateDetails']);
        Route::get('personal-details', [RiderController::class, 'Personaletails']);
        Route::get('address-details', [RiderController::class, 'addressDetails']);
        Route::get('legal-details', [RiderController::class, 'legalDetails']);
        

        Route::post('toggle-availability', [RiderOrderController::class, 'toggleAvailability']);
        Route::get('orders/requests', [RiderOrderController::class, 'riderRequestedOrders']);
        Route::post('order/{order_id}/accept', [RiderOrderController::class, 'acceptOrder']);
        Route::post('order/{order_id}/reject', [RiderOrderController::class, 'rejectOrder']);
        Route::get('orders/accepted-orders', [RiderOrderController::class, 'riderAcceptedOrders']);
        Route::get('orders/accepted-orders/{order_id}', [RiderOrderController::class, 'riderOrderDetail']);
        Route::post('start-rider', [RiderOrderController::class, 'startRideByRider']);
        Route::post('update-location', [RiderOrderController::class,'updateRiderLocation']);
        Route::post('complete-delivery', [RiderOrderController::class,'verifyDeliveryOtp']);
        Route::get('delivered-orders', [RiderOrderController::class,'riderDeliveredOrders']);
        Route::get('delivered-orders/{order_id}', [RiderOrderController::class, 'riderDeliveredOrderDetail']);
        Route::get('earnings', [RiderOrderController::class, 'riderEarnings']);
    });
});




Route::prefix('admin')->group(function () {

    Route::post('register', [AdminController::class, 'register']);
    Route::post('login', [AdminController::class, 'login']);

    Route::middleware('auth:admin')->group(function () {
        Route::get('profile', [AdminController::class, 'profile']);
        Route::post('logout', [AdminController::class, 'logout']);
        Route::post('refresh', [AdminController::class, 'refresh']);
    });

});


