import WebSocket from 'ws';

const RIDER_ID = 4;
const REVERB_HOST = '127.0.0.1';
const REVERB_PORT = 8080;
const REVERB_KEY  = 'lqqq9bmdtm8z12hldcrm';

const url = `ws://${REVERB_HOST}:${REVERB_PORT}/app/${REVERB_KEY}?protocol=7&client=js&version=1.0`;

console.log('🌐 Connecting to Reverb...');

const ws = new WebSocket(url);

ws.on('open', () => {
    console.log('✅ Connected to Reverb WS');

    ws.send(JSON.stringify({
        event: 'subscribe',
        channel: `rider-tracking.${RIDER_ID}`
    }));

    console.log(`📡 Subscribed to rider-tracking.${RIDER_ID}`);
});

ws.on('message', (message) => {
    try {
        const data = JSON.parse(message.toString());
        console.log('📩 Incoming message:', data);

        // If it's a rider location update
        if (data.event === 'location.updated') {
            console.log('📍 Rider Location Update:', data.data);
        }
    } catch (err) {
        console.error('⚠️ Error parsing message:', err);
    }
});



ws.on('close', () => console.log('❌ Disconnected from Reverb'));
ws.on('error', (err) => console.error('❌ WebSocket error:', err));
