

<?php $__env->startSection('title', 'Product Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER (FIXED)
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: .05em;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead tr {
    background: none !important;
}

/* Rounded header */
.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

/* Space below search bar */
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* Space above table */
.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    font-size: 14px;
    color: #374151;
    border-top: 1px solid #eef2f6;
    text-align: center;
}

/* Zebra rows */
table.dataTable tbody tr:nth-child(odd) {
    background-color: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background-color: #ffffff;
}

/* ===============================
   ANIMATED ROW HOVER (PRO)
=============================== */
table.dataTable tbody tr {
    transition: all 0.25s ease;
}

table.dataTable tbody tr:hover {
    background-color: #e9f6ff !important;
    /* transform: scale(1.01); */
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
    z-index: 2;
    position: relative;
}

/* ===============================
   SCROLLABLE TABLE
=============================== */
.table-responsive {
    overflow-x: auto !important;
}

/* ===============================
   STATUS BADGES
=============================== */
.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }

/* ===============================
   ACTION BUTTONS
=============================== */
.action-btn {
    border: none;
    background: none;
    font-size: 20px;
    margin: 0 6px;
    cursor: pointer;
}
.action-edit { color: #f59e0b; }

/* ===========================
   MODAL DESIGN
=========================== */

/* ===========================
   MODAL PERFECT ALIGNMENT
=========================== */

/* Ensure modal-dialog centers properly */
.modal-dialog {
    max-width: 500px; /* responsive max width */
    width: 90%;
    justify-content: center !important;
}

/* Modal content style */
.modal-content {
    border-radius: 1rem;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

/* Modal header */
.modal-header {
    padding: 1rem 1.5rem;
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
}

/* Modal body with scroll if content is tall */
.modal-body {
    max-height: 60vh;
    overflow-y: auto;
    padding: 1.5rem;
}

/* Inputs styling */
.modal-body .form-control,
.modal-body .form-select {
    box-shadow: none;
    border: 1px solid #ced4da;
    transition: 0.2s;
}

.modal-body .form-control:focus,
.modal-body .form-select:focus {
    border-color: #29b2f6;
    box-shadow: 0 0 5px rgba(41,178,246,0.3);
    outline: none;
}

/* Modal footer */
.modal-footer {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 1.5rem;
    border-top: none;
    background: #f9f9f9;
}

/* Buttons hover effect */
.modal-footer .btn:hover {
    transform: translateY(-2px);
    transition: 0.2s;
}

/* Scrollbar inside modal */
.modal-body::-webkit-scrollbar {
    width: 6px;
}

.modal-body::-webkit-scrollbar-thumb {
    background: rgba(41,178,246,0.5);
    border-radius: 10px;
}

.modal-body::-webkit-scrollbar-track {
    background: transparent;
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}

/* ===============================
   MODERN ICON BUTTONS
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    background: #f1f5f9;
    cursor: pointer;
    transition: all 0.2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* Edit */
.edit-btn {
    color: #0d6efd;
}
.edit-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* Delete */
.delete-btn {
    color: #dc3545;
}
.delete-btn:hover {
    background: rgba(220,53,69,.15);
    transform: translateY(-2px);
}

.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
    text-decoration: none;
}
.btn-back {
    background: #f1f5f9;
    color: #374151;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: 1px solid;
    transition: all .2s ease;
    text-decoration: none;
}

.btn-back:hover {
    background: #e2e8f0;
}

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Product Management</h3>

        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.products.create')); ?>"
            class="btn-add">
                <i class="fa fa-plus me-2"></i> Add Product
            </a>

            <a href="<?php echo e(route('admin.dashboard')); ?>"
            class="btn-back d-flex align-items-center">
                <i class="fa fa-arrow-left me-2"></i> Dashboard
            </a>
        </div>
    </div>


    <div class="card border-0 shadow-lg rounded-4">
        <div class="card-body">
            <div class="table-responsive">
                <table id="common-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Image</th>
                            <th>Category</th>
                            <th>Brand</th>
                            <th>Unit</th>
                            <th>Store Price</th>
                            <th>Customer Price</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td class="text-center">
                                <img src="<?php echo e($product->image 
                                    ? asset($product->image) 
                                    : asset('images/no-image.png')); ?>"
                                    alt="Product Image"
                                    width="55"
                                    height="55"
                                    class="rounded-3 object-fit-cover">
                            </td>
                            <td style="text-align:left">
                                <div class="fw-semibold"><?php echo e($product->category ?? '-'); ?></div>
                                <small class="text-muted"><?php echo e($product->subcategory ?? '-'); ?></small>
                            </td>
                            <td><?php echo e($product->brand ?? '-'); ?></td>
                            <td><?php echo e($product->quantityUnit->name ?? '-'); ?></td>

                            <td>
                                <div class="fw-semibold">
                                    ₹<?php echo e(number_format($product->store_price, 2)); ?>

                                </div>

                                <?php if($product->store_discount_value > 0): ?>
                                    <?php
                                        if($product->store_discount_type === 'percentage'){
                                            $storeDiscounted = $product->store_price - ($product->store_price * $product->store_discount_value / 100);
                                            $storeLabel = $product->store_discount_value . '% OFF';
                                        } else {
                                            $storeDiscounted = $product->store_price - $product->store_discount_value;
                                            $storeLabel = '₹' . number_format($product->store_discount_value,2) . ' OFF';
                                        }
                                    ?>

                                    <div class="text-success small fw-semibold">
                                        ₹<?php echo e(number_format($storeDiscounted, 2)); ?>

                                    </div>
                                    <div class="text-muted small">
                                        (<?php echo e($storeLabel); ?>)
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td>
                                <div class="fw-semibold">
                                    ₹<?php echo e(number_format($product->customer_price, 2)); ?>

                                </div>

                                <?php if($product->customer_discount_value > 0): ?>
                                    <?php
                                        if($product->customer_discount_type === 'percentage'){
                                            $customerDiscounted = $product->customer_price - ($product->customer_price * $product->customer_discount_value / 100);
                                            $customerLabel = $product->customer_discount_value . '% OFF';
                                        } else {
                                            $customerDiscounted = $product->customer_price - $product->customer_discount_value;
                                            $customerLabel = '₹' . number_format($product->customer_discount_value,2) . ' OFF';
                                        }
                                    ?>

                                    <div class="text-success small fw-semibold">
                                        ₹<?php echo e(number_format($customerDiscounted, 2)); ?>

                                    </div>
                                    <div class="text-muted small">
                                        (<?php echo e($customerLabel); ?>)
                                    </div>
                                <?php endif; ?>
                            </td>


                            <td>
                                <span class="status status-<?php echo e($product->status); ?>">
                                    <?php echo e(ucfirst($product->status)); ?>

                                </span>
                            </td>

                            <td class="text-center gap-1">

                                <button class="icon-btn edit-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#pricingModal"
                                    data-id="<?php echo e($product->id); ?>"
                                    data-store="<?php echo e($product->store_price); ?>"
                                    data-customer="<?php echo e($product->customer_price); ?>"
                                    data-store-discount-type="<?php echo e($product->store_discount_type); ?>"
                                    data-store-discount-value="<?php echo e($product->store_discount_value); ?>"
                                    data-customer-discount-type="<?php echo e($product->customer_discount_type); ?>"
                                    data-customer-discount-value="<?php echo e($product->customer_discount_value); ?>"
                                    data-status="<?php echo e($product->status); ?>"
                                    title="Quick Price & Discount Edit">
                                    <i class="fa-solid fa-indian-rupee-sign"></i>
                                </button>


                                <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>"
                                class="icon-btn edit-btn"
                                title="Full Edit">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </a>

                                <button class="icon-btn delete-btn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#deleteModal"
                                    data-id="<?php echo e($product->id); ?>"
                                    data-name="<?php echo e($product->material_name); ?>"
                                    title="Delete">
                                    <i class="fa-solid fa-trash"></i>
                                </button>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="pricingModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="pricingForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>
            <div class="modal-content shadow-lg rounded-4 border-0">
                
                
                <div class="modal-header bg-gradient-primary text-white rounded-top-4">
                    <h5 class="modal-title fw-bold">Edit Product Pricing</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                
                <div class="modal-body p-4">

                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Store Price</label>
                        <input type="number" step="0.01" id="store_price" name="store_price" class="form-control" required>
                    </div>

                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Store Discount Type</label>
                            <select id="store_discount_type" name="store_discount_type" class="form-select">
                                <option value="">No Discount</option>
                                <option value="percentage">Percentage (%)</option>
                                <option value="amount">Amount (₹)</option>
                            </select>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Store Discount Value</label>
                            <input type="number" step="0.01" id="store_discount_value" name="store_discount_value" class="form-control">
                        </div>
                    </div>

                    <hr>

                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Customer Price</label>
                        <input type="number" step="0.01" id="customer_price" name="customer_price" class="form-control" required>
                    </div>

                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Customer Discount Type</label>
                            <select id="customer_discount_type" name="customer_discount_type" class="form-select">
                                <option value="">No Discount</option>
                                <option value="percentage">Percentage (%)</option>
                                <option value="amount">Amount (₹)</option>
                            </select>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Customer Discount Value</label>
                            <input type="number" step="0.01" id="customer_discount_value" name="customer_discount_value" class="form-control">
                        </div>
                    </div>

                    <hr>

                    
                    <div class="mb-0">
                        <label class="form-label fw-semibold">Status</label>
                        <select id="status" name="status" class="form-select">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>

                </div>

                
                <div class="modal-footer justify-content-between px-4 py-3 border-0">
                    <button type="submit" class="btn btn-success rounded-pill px-4 py-2">
                        Save Changes
                    </button>
                    <button type="button" class="btn btn-outline-secondary rounded-pill px-4 py-2" 
                            data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <div class="modal-content shadow-lg rounded-4 border-0">
                
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title fw-bold">Confirm Delete</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body p-4">
                    <p class="mb-0">Are you sure you want to delete <strong id="deleteItemName"></strong>?</p>
                </div>

                <div class="modal-footer justify-content-between px-4 py-3 border-0">
                    <button type="submit" class="btn btn-danger rounded-pill px-4 py-2">
                        Delete
                    </button>
                    <button type="button" class="btn btn-outline-secondary rounded-pill px-4 py-2" 
                            data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </div>
        </form>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#common-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: 8 }]
    });

    $('#pricingModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        $('#store_price').val(btn.data('store'));
        $('#customer_price').val(btn.data('customer'));

        $('#store_discount_type').val(btn.data('store-discount-type'));
        $('#store_discount_value').val(btn.data('store-discount-value'));

        $('#customer_discount_type').val(btn.data('customer-discount-type'));
        $('#customer_discount_value').val(btn.data('customer-discount-value'));

        $('#status').val(btn.data('status'));

        let url = "<?php echo e(route('admin.products.update-pricing', ':id')); ?>";
        $('#pricingForm').attr('action', url.replace(':id', btn.data('id')));
    });


    $('#deleteModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);
        let id = btn.data('id');
        let name = btn.data('name');

        $('#deleteItemName').text(name);

        let url = "<?php echo e(route('admin.products.destroy', ':id')); ?>";
        $('#deleteForm').attr('action', url.replace(':id', id));
    });


});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/products/index.blade.php ENDPATH**/ ?>