

<?php $__env->startSection('title', isset($product) ? 'Edit Product' : 'Add Product'); ?>

<?php $__env->startSection('content'); ?>


<style>
/* Card */
.form-card {
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,.08);
}

/* Header */
.form-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    padding: 16px 24px;
}

/* Inputs */
.form-control, .form-select {
    border-radius: 10px;
    border: 1px solid #ced4da;
    box-shadow: none;
}

.form-control:focus, .form-select:focus {
    border-color: #29B2F6;
    box-shadow: 0 0 0 3px rgba(41,178,246,.15);
}

/* Labels */
.form-label {
    font-weight: 600;
    font-size: 14px;
    color: #374151;
}

/* Buttons */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 22px;
    padding: 10px 26px;
    font-weight: 600;
    border: none;
}

.btn-add:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(41,178,246,.35);
}

.btn-outline-secondary {
    border-radius: 22px;
    padding: 10px 24px;
}

/* Section spacing */
.form-section {
    padding: 24px;
}

/* Error UI */
.is-invalid {
    border-color: #dc3545 !important;
}

.invalid-feedback {
    font-size: 13px;
    color: #dc3545;
    font-weight: 500;
}

</style>

<div class="container-fluid">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">
            <?php echo e(isset($product) ? 'Edit Product' : 'Add Product'); ?>

        </h3>

        <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-outline-secondary btn-sm">
            ← Back
        </a>
    </div>

    
    <div class="card form-card">
        <div class="form-header">
            <h6 class="mb-0 fw-semibold">
                <i class="fa fa-box me-2"></i>
                Product Information
            </h6>
        </div>

        <div class="form-section">

            <?php if($errors->has('product')): ?>
                <div class="alert alert-danger mb-3">
                    <?php echo e($errors->first('product')); ?>

                </div>
            <?php endif; ?>

            <form method="POST"
                  enctype="multipart/form-data"
                  action="<?php echo e(isset($product)
                            ? route('admin.products.update', $product)
                            : route('admin.products.store')); ?>">

                <?php echo csrf_field(); ?>
                <?php if(isset($product)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <div class="row g-3">

                    
                    <div class="col-md-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" id="category"
                                class="form-select <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <option value="">Category</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($c->id); ?>" data-name="<?php echo e(strtolower($c->name)); ?>"
                                    <?php if(old('category_id', $product->category_id ?? '') == $c->id): echo 'selected'; endif; ?>>
                                    <?php echo e($c->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Sub Category</label>
                        <select name="subcategory_id" id="subcategory"
                                class="form-select"
                                data-selected="<?php echo e(old('subcategory_id', $product->subcategory_id ?? '')); ?>">
                            <option value="">Sub Category</option>
                            <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($s->id); ?>"
                                    <?php if(old('subcategory_id', $product->subcategory_id ?? '') == $s->id): echo 'selected'; endif; ?>>
                                    <?php echo e($s->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Brand</label>
                        <select name="brand_id" id="brand"
                                class="form-select"
                                data-selected="<?php echo e(old('brand_id', $product->brand_id ?? '')); ?>">
                            <option value="">Brand</option>
                            <?php if(isset($product) && $product->brand_id): ?>
                                <option value="<?php echo e($product->brand_id); ?>" selected>
                                    <?php echo e($product->brand->name ?? ''); ?>

                                </option>
                            <?php endif; ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label">Quantity Unit</label>
                        <select name="quantity_unit_id" id="quantity_unit"
                                class="form-select select2"
                                data-selected="<?php echo e(old('quantity_unit_id', $product->quantity_unit_id ?? '')); ?>">
                            <option value="">Unit</option>
                            <?php if(isset($product) && $product->quantity_unit_id): ?>
                                <option value="<?php echo e($product->quantity_unit_id); ?>" selected>
                                    <?php echo e($product->quantityUnit->name ?? ''); ?>

                                </option>
                            <?php endif; ?>
                        </select>
                    </div>

                    
                    <div class="col-md-4">
                        <label class="form-label">Product Image</label>
                        <input type="file"
                               name="image"
                               class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               accept="image/*">
                    </div>

                    <div class="col-md-4">
                        <?php if(isset($product) && $product->image): ?>
                            <div>
                                <label class="form-label">Preview</label><br>
                                <img src="<?php echo e(asset($product->image)); ?>"
                                     class="img-thumbnail"
                                     width="120"
                                     onerror="this.src='<?php echo e(asset('images/no-image.png')); ?>'">
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" <?php if(old('status', $product->status ?? '')=='active'): echo 'selected'; endif; ?>>Active</option>
                            <option value="inactive" <?php if(old('status', $product->status ?? '')=='inactive'): echo 'selected'; endif; ?>>Inactive</option>
                        </select>
                    </div>

                    
                    <div class="col-12 mt-2">
                        <hr>
                        <h6 class="fw-semibold text-muted mb-2">
                            <i class="fa fa-tag me-2"></i> Pricing & Discounts
                        </h6>
                    </div>

                    
                    <div class="col-md-4">
                        <label class="form-label">Store Price</label>
                        <input type="number" step="0.01"
                               name="store_price"
                               class="form-control"
                               value="<?php echo e(old('store_price', $product->store_price ?? '')); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Store Disc Type</label>
                        <select name="store_discount_type" class="form-select">
                            <option value="">None</option>
                            <option value="percentage"
                                <?php if(old('store_discount_type', $product->store_discount_type ?? '') == 'percentage'): echo 'selected'; endif; ?>>
                                %
                            </option>
                            <option value="amount"
                                <?php if(old('store_discount_type', $product->store_discount_type ?? '') == 'amount'): echo 'selected'; endif; ?>>
                                ₹
                            </option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Store Disc Value</label>
                        <input type="number" step="0.01"
                            name="store_discount_value"
                            class="form-control"
                            value="<?php echo e(old('store_discount_value', $product->store_discount_value ?? '')); ?>">
                    </div>

                    

                    
                    <div class="col-md-4">
                        <label class="form-label">Customer Price</label>
                        <input type="number" step="0.01"
                               name="customer_price"
                               class="form-control"
                               value="<?php echo e(old('customer_price', $product->customer_price ?? '')); ?>">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Cust Disc Type</label>
                        <select name="customer_discount_type" class="form-select">
                            <option value="">None</option>
                            <option value="percentage"
                                <?php if(old('customer_discount_type', $product->customer_discount_type ?? '') == 'percentage'): echo 'selected'; endif; ?>>
                                %
                            </option>
                            <option value="amount"
                                <?php if(old('customer_discount_type', $product->customer_discount_type ?? '') == 'amount'): echo 'selected'; endif; ?>>
                                ₹
                            </option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Cust Disc Value</label>
                        <input type="number" step="0.01"
                            name="customer_discount_value"
                            class="form-control"
                            value="<?php echo e(old('customer_discount_value', $product->customer_discount_value ?? '')); ?>">
                    </div>

                    
                    <div class="col-12">
                        <label class="form-label">Product Description</label>
                        <textarea name="description"
                                  class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  rows="3"
                                  placeholder="Enter product description"><?php echo e(old('description', $product->description ?? '')); ?></textarea>
                    </div>

                </div>

                
                <div class="col-12 mt-3" id="colors-section" style="display: none;">
                    <label class="form-label fw-semibold">Available Colors</label>

                    <div id="colors-wrapper">
                        <?php if(old('colors', $product->colors ?? false)): ?>
                            <?php $__currentLoopData = old('colors', $product->colors ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row g-2 align-items-center color-row mb-2">
                                    <div class="col-md-4">
                                        <input type="text"
                                               name="colors[<?php echo e($i); ?>][name]"
                                               class="form-control"
                                               placeholder="Color Name"
                                               value="<?php echo e($color['name'] ?? ''); ?>">
                                    </div>

                                    <div class="col-md-3">
                                        <input type="color"
                                               name="colors[<?php echo e($i); ?>][hex]"
                                               class="form-control form-control-color"
                                               value="<?php echo e($color['hex'] ?? '#000000'); ?>">
                                    </div>

                                    <div class="col-md-2">
                                        <button type="button" class="btn btn-danger btn-sm remove-color">
                                            Remove
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>

                    <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="add-color">
                        + Add Color
                    </button>
                </div>

                
                <div class="d-flex justify-content-end gap-3 mt-4">
                    <a href="<?php echo e(route('admin.products')); ?>" class="btn btn-outline-secondary">
                        Cancel
                    </a>

                    <button class="btn-add">
                        <i class="fa fa-save me-2"></i>
                        <?php echo e(isset($product) ? 'Update Product' : 'Save Product'); ?>

                    </button>
                </div>

            </form>
        </div>
    </div>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
document.addEventListener('DOMContentLoaded', function () {

    let colorIndex = document.querySelectorAll('.color-row').length;

    document.getElementById('add-color').addEventListener('click', function () {
        const wrapper = document.getElementById('colors-wrapper');

        const html = `
            <div class="row g-2 align-items-center color-row mb-2">
                <div class="col-md-5">
                    <input type="text"
                           name="colors[${colorIndex}][name]"
                           class="form-control"
                           placeholder="Color Name">
                </div>

                <div class="col-md-4">
                    <input type="color"
                           name="colors[${colorIndex}][hex]"
                           class="form-control form-control-color"
                           value="#000000">
                </div>

                <div class="col-md-3">
                    <button type="button" class="btn btn-danger btn-sm remove-color">
                        Remove
                    </button>
                </div>
            </div>
        `;

        wrapper.insertAdjacentHTML('beforeend', html);
        colorIndex++;
    });

    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('remove-color')) {
            e.target.closest('.color-row').remove();
        }
    });

});
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    const categorySelect = document.getElementById('category');
    const colorsSection = document.getElementById('colors-section');

    function toggleColors() {
        const selectedOption = categorySelect.options[categorySelect.selectedIndex];
        const categoryName = selectedOption?.dataset?.name;

        if (categoryName === 'paint') {
            colorsSection.style.display = 'block';
        } else {
            colorsSection.style.display = 'none';
        }
    }

    toggleColors(); // edit mode
    categorySelect.addEventListener('change', toggleColors);
});
</script>




<script>
document.addEventListener('DOMContentLoaded', function () {

    const categorySelect = document.getElementById('category');
    const subSelect      = document.getElementById('subcategory');
    const unitSelect     = document.getElementById('quantity_unit');
    const brandSelect    = document.getElementById('brand');

    function loadByCategory(categoryId) {
        if (!categoryId) return;

        // SUBCATEGORIES
        fetch(`/admin/subcategories/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = subSelect.dataset.selected;
                subSelect.innerHTML = '<option value="">Select Sub Category</option>';
                data.forEach(item => {
                    subSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });

        fetch(`/admin/quantity-units/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = unitSelect.dataset.selected;
                unitSelect.innerHTML = '<option value="">Select Quantity Unit</option>';
                data.forEach(item => {
                    unitSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });

        fetch(`/admin/brands/by-category/${categoryId}`)
            .then(res => res.json())
            .then(data => {
                const selected = brandSelect.dataset.selected;
                brandSelect.innerHTML = '<option value="">Select Brand</option>';
                data.forEach(item => {
                    brandSelect.innerHTML +=
                        `<option value="${item.id}" ${item.id == selected ? 'selected' : ''}>
                            ${item.name}
                        </option>`;
                });
            });
    }

    // ON CHANGE
    categorySelect.addEventListener('change', function () {
        loadByCategory(this.value);
    });

    // 🔥 AUTO LOAD FOR EDIT MODE
    if (categorySelect.value) {
        loadByCategory(categorySelect.value);
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/buildours/live-app.buildours.in/resources/views/admin/products/form.blade.php ENDPATH**/ ?>