

<?php $__env->startSection('title', 'Brand Management'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet">

<style>
/* ===============================
   DATATABLE HEADER
=============================== */
.dataTables_wrapper table.dataTable thead th {
    background: linear-gradient(to bottom, #29B2F6, #5AF399) !important;
    color: #fff !important;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    text-align: center;
    border: none !important;
}

.dataTables_wrapper table.dataTable thead th:first-child {
    border-top-left-radius: 12px;
}
.dataTables_wrapper table.dataTable thead th:last-child {
    border-top-right-radius: 12px;
}

.dataTables_wrapper table.dataTable {
    margin-top: 12px !important;
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 16px;
}

/* ===============================
   TABLE BODY
=============================== */
table.dataTable tbody td {
    text-align: center;
    font-size: 14px;
    border-top: 1px solid #eef2f6;
}

table.dataTable tbody tr:nth-child(odd) {
    background: #f8fbff;
}
table.dataTable tbody tr:nth-child(even) {
    background: #fff;
}

table.dataTable tbody tr {
    transition: all .25s ease;
}
table.dataTable tbody tr:hover {
    background: #e9f6ff !important;
    box-shadow: 0 6px 18px rgba(41,178,246,.15);
}

/* Active page button */
.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #29B2F6, #5AF399) !important;
    color: #ffffff !important;
    border: none !important;
    border-radius: 8px !important;
    box-shadow: 0 4px 10px rgba(41,178,246,.35);
}
/* ===============================
   ICON ACTION BUTTONS (FIXED)
=============================== */
.icon-btn {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    border: none;
    background: #f1f5f9;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all .2s ease;
}

.icon-btn i {
    font-size: 15px;
}

/* EDIT */
.approve-btn {
    color: #0d6efd !important;
}
.approve-btn:hover {
    background: rgba(13,110,253,.15);
    transform: translateY(-2px);
}

/* DELETE */
.reject-btn {
    color: #ef4444 !important;
}
.reject-btn:hover {
    background: rgba(239,68,68,.15);
    transform: translateY(-2px);
}


/* ===============================
   ADD BUTTON
=============================== */
.btn-add {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-radius: 20px;
    padding: 8px 20px;
    font-weight: 600;
    border: none;
}

/* ===============================
   MODAL FIX (CENTERED & CLEAN)
=============================== */
.modal {
    overflow-y: auto;
    padding-right: 0 !important;
}

.modal-dialog.modal-wide {
    max-width: 900px;   /* change as you want */
    width: 90%;
}


.modal-dialog {
    margin: auto !important;
    max-width: 500px !important;
    justify-content: center !important;
}

.modal-content {
    border-radius: 14px;
    border: none;
    box-shadow: 0 15px 40px rgba(0,0,0,.15);
}

.modal-header {
    background: linear-gradient(135deg, #29B2F6, #5AF399);
    color: #fff;
    border-top-left-radius: 14px;
    border-top-right-radius: 14px;
}

.modal-footer .btn {
    border-radius: 20px;
}

/* ===============================
   INPUTS
=============================== */
.form-control {
    border-radius: 10px;
}

/* ===============================
   MOBILE FIX
=============================== */
@media (max-width: 768px) {
    .table-responsive {
        overflow-x: auto;
    }
    table.dataTable {
        min-width: 700px;
    }
}

.status {
    padding: 6px 16px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 30px;
    display: inline-block;
}

.status-active { background: #e6f9f0; color: #1e8e5a; }
.status-inactive { background: #fdecea; color: #c62828; }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-semibold">Brand Management</h3>
        <button class="btn-add" data-bs-toggle="modal" data-bs-target="#addBrandModal">
            <i class="fa fa-plus me-2"></i> Add Brand
        </button>
    </div>

    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="brand-table" class="display w-100">
                    <thead>
                        <tr>
                            <th>S.no</th>
                            <th>Brand</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td class="fw-semibold"><?php echo e($brand->name); ?></td>

                            <td>
                                <?php if($brand->category_ids): ?>
                                    <?php $__currentLoopData = $brand->category_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($categories->firstWhere('id', $catId)->name ?? 'Unknown'); ?>

                                        <?php if(!$loop->last): ?>, <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </td>

                            <td>
                                <span class="status status-<?php echo e($brand->status); ?>">
                                    <?php echo e(ucfirst($brand->status)); ?>

                                </span>
                            </td>

                            <td>
                                <button class="icon-btn approve-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#editBrandModal"
                                        data-id="<?php echo e($brand->id); ?>"
                                        data-name="<?php echo e($brand->name); ?>"
                                        data-status="<?php echo e($brand->status); ?>"
                                        data-categories="<?php echo e(json_encode($brand->category_ids)); ?>">
                                    <i class="fa fa-pen"></i>
                                </button>

                                <button class="icon-btn reject-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteBrandModal"
                                        data-id="<?php echo e($brand->id); ?>"
                                        data-name="<?php echo e($brand->name); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="addBrandModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-wide">
        <form method="POST" action="<?php echo e(route('admin.brands.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Brand</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <label class="detail-label mb-1">Brand Name</label>
                    <input type="text" name="name" class="form-control" placeholder="Eg: Tata, Amul" required>

                    <label class="detail-label mb-1 mt-3">Categories</label>
                    <div class="mb-2">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input class="form-check-input"
                                       type="checkbox"
                                       name="category_ids[]"
                                       value="<?php echo e($cat->id); ?>"
                                       id="addBrandCategory<?php echo e($cat->id); ?>">
                                <label class="form-check-label" for="addBrandCategory<?php echo e($cat->id); ?>">
                                    <?php echo e($cat->name); ?>

                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Save</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="editBrandModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="editBrandForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="modal-content">
                <div class="modal-header">
                    <h5>Edit Brand</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <label class="detail-label mb-1">Brand Name</label>
                    <input type="text" name="name" id="editBrandName" class="form-control" required>

                    <label class="detail-label mb-1 mt-3">Categories</label>
                    <div id="editBrandCategories" class="mb-2">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input class="form-check-input"
                                       type="checkbox"
                                       name="category_ids[]"
                                       value="<?php echo e($cat->id); ?>"
                                       id="editBrandCategory<?php echo e($cat->id); ?>">
                                <label class="form-check-label" for="editBrandCategory<?php echo e($cat->id); ?>">
                                    <?php echo e($cat->name); ?>

                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <label class="detail-label mb-1 mt-3">Status</label>
                    <select name="status" id="editBrandStatus" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>

                    <span id="brandStatusPreview" class="status mt-2 d-inline-block"></span>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-success px-4">Update</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>



<div class="modal fade" id="deleteBrandModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <form method="POST" id="deleteBrandForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>

            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5>Confirm Delete</h5>
                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    Are you sure you want to delete
                    <strong id="deleteBrandName"></strong>?
                </div>

                <div class="modal-footer">
                    <button class="btn btn-danger px-4">Delete</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script>
$(function () {

    $('#brand-table').DataTable({
        pageLength: 10,
        columnDefs: [{ orderable: false, targets: 4 }]
    });

    $('#editBrandModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        let categories = btn.data('categories') || [];

        $('#editBrandName').val(btn.data('name'));
        $('#editBrandStatus').val(btn.data('status'));

        $('#editBrandCategories input[type="checkbox"]').prop('checked', false);

        categories.forEach(function(catId){
            $('#editBrandCategory' + catId).prop('checked', true);
        });

        $('#brandStatusPreview')
            .attr('class', 'status status-' + btn.data('status'))
            .text(btn.data('status').charAt(0).toUpperCase() + btn.data('status').slice(1));

        $('#editBrandForm').attr(
            'action',
            "<?php echo e(route('admin.brands.update', ':id')); ?>".replace(':id', btn.data('id'))
        );
    });

    $('#editBrandStatus').on('change', function(){
        let val = $(this).val();
        $('#brandStatusPreview')
            .attr('class', 'status status-' + val)
            .text(val.charAt(0).toUpperCase() + val.slice(1));
    });

    $('#deleteBrandModal').on('show.bs.modal', function (e) {
        let btn = $(e.relatedTarget);

        $('#deleteBrandName').text(btn.data('name'));
        $('#deleteBrandForm').attr(
            'action',
            "<?php echo e(route('admin.brands.destroy', ':id')); ?>".replace(':id', btn.data('id'))
        );
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Freshora\Laravel\buildours\resources\views/admin/products/brand.blade.php ENDPATH**/ ?>