<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class RoutePolicy extends \Google\Collection
{
  /**
   * The Route Policy is an Export Policy.
   */
  public const TYPE_ROUTE_POLICY_TYPE_EXPORT = 'ROUTE_POLICY_TYPE_EXPORT';
  /**
   * The Route Policy is an Import Policy.
   */
  public const TYPE_ROUTE_POLICY_TYPE_IMPORT = 'ROUTE_POLICY_TYPE_IMPORT';
  protected $collection_key = 'terms';
  /**
   * An optional description of route policy.
   *
   * @var string
   */
  public $description;
  /**
   * A fingerprint for the Route Policy being applied to this Router, which is
   * essentially a hash of the Route Policy used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update Route Policy. You must always provide an
   * up-to-date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make a getRoutePolicy() request to retrieve
   * a Route Policy.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * Route Policy name, which must be a resource ID segment and unique within
   * all the router's Route Policies. Name should conform to RFC1035.
   *
   * @var string
   */
  public $name;
  protected $termsType = RoutePolicyPolicyTerm::class;
  protected $termsDataType = 'array';
  /**
   * @var string
   */
  public $type;

  /**
   * An optional description of route policy.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * A fingerprint for the Route Policy being applied to this Router, which is
   * essentially a hash of the Route Policy used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update Route Policy. You must always provide an
   * up-to-date fingerprint hash in order to update or change labels.
   *
   * To see the latest fingerprint, make a getRoutePolicy() request to retrieve
   * a Route Policy.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * Route Policy name, which must be a resource ID segment and unique within
   * all the router's Route Policies. Name should conform to RFC1035.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * List of terms (the order in the list is not important, they are evaluated
   * in order of priority). Order of policies is not retained and might change
   * when getting policy later.
   *
   * @param RoutePolicyPolicyTerm[] $terms
   */
  public function setTerms($terms)
  {
    $this->terms = $terms;
  }
  /**
   * @return RoutePolicyPolicyTerm[]
   */
  public function getTerms()
  {
    return $this->terms;
  }
  /**
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RoutePolicy::class, 'Google_Service_Compute_RoutePolicy');
