<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class Country extends \Google\Model
{
  /**
   * Country code.
   *
   * @var string
   */
  public $countryCode;
  /**
   * DART ID of this country. This is the ID used for targeting and generating
   * reports.
   *
   * @var string
   */
  public $dartId;
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#country".
   *
   * @var string
   */
  public $kind;
  /**
   * Name of this country.
   *
   * @var string
   */
  public $name;
  /**
   * Whether ad serving supports secure servers in this country.
   *
   * @var bool
   */
  public $sslEnabled;

  /**
   * Country code.
   *
   * @param string $countryCode
   */
  public function setCountryCode($countryCode)
  {
    $this->countryCode = $countryCode;
  }
  /**
   * @return string
   */
  public function getCountryCode()
  {
    return $this->countryCode;
  }
  /**
   * DART ID of this country. This is the ID used for targeting and generating
   * reports.
   *
   * @param string $dartId
   */
  public function setDartId($dartId)
  {
    $this->dartId = $dartId;
  }
  /**
   * @return string
   */
  public function getDartId()
  {
    return $this->dartId;
  }
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#country".
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Name of this country.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Whether ad serving supports secure servers in this country.
   *
   * @param bool $sslEnabled
   */
  public function setSslEnabled($sslEnabled)
  {
    $this->sslEnabled = $sslEnabled;
  }
  /**
   * @return bool
   */
  public function getSslEnabled()
  {
    return $this->sslEnabled;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Country::class, 'Google_Service_Dfareporting_Country');
