<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class ListInvoicesResponse extends \Google\Collection
{
  protected $collection_key = 'invoices';
  protected $invoicesType = Invoice::class;
  protected $invoicesDataType = 'array';
  /**
   * A token to retrieve the next page of results. Pass this value in the
   * page_token field in the subsequent call to `ListInvoices` method to
   * retrieve the next page of results. This token will be absent if there are
   * no more invoices to return.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The list of invoices. This list will be absent if empty.
   *
   * @param Invoice[] $invoices
   */
  public function setInvoices($invoices)
  {
    $this->invoices = $invoices;
  }
  /**
   * @return Invoice[]
   */
  public function getInvoices()
  {
    return $this->invoices;
  }
  /**
   * A token to retrieve the next page of results. Pass this value in the
   * page_token field in the subsequent call to `ListInvoices` method to
   * retrieve the next page of results. This token will be absent if there are
   * no more invoices to return.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListInvoicesResponse::class, 'Google_Service_DisplayVideo_ListInvoicesResponse');
