<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ToolResults;

class ToolExitCode extends \Google\Model
{
  /**
   * Tool execution exit code. A value of 0 means that the execution was
   * successful. - In response: always set - In create/update request: always
   * set
   *
   * @var int
   */
  public $number;

  /**
   * Tool execution exit code. A value of 0 means that the execution was
   * successful. - In response: always set - In create/update request: always
   * set
   *
   * @param int $number
   */
  public function setNumber($number)
  {
    $this->number = $number;
  }
  /**
   * @return int
   */
  public function getNumber()
  {
    return $this->number;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ToolExitCode::class, 'Google_Service_ToolResults_ToolExitCode');
