<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTubeReporting;

class Report extends \Google\Model
{
  /**
   * The date/time when this report was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * The URL from which the report can be downloaded (max. 1000 characters).
   *
   * @var string
   */
  public $downloadUrl;
  /**
   * The end of the time period that the report instance covers. The value is
   * exclusive.
   *
   * @var string
   */
  public $endTime;
  /**
   * The server-generated ID of the report.
   *
   * @var string
   */
  public $id;
  /**
   * The date/time when the job this report belongs to will expire/expired.
   *
   * @var string
   */
  public $jobExpireTime;
  /**
   * The ID of the job that created this report.
   *
   * @var string
   */
  public $jobId;
  /**
   * The start of the time period that the report instance covers. The value is
   * inclusive.
   *
   * @var string
   */
  public $startTime;

  /**
   * The date/time when this report was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * The URL from which the report can be downloaded (max. 1000 characters).
   *
   * @param string $downloadUrl
   */
  public function setDownloadUrl($downloadUrl)
  {
    $this->downloadUrl = $downloadUrl;
  }
  /**
   * @return string
   */
  public function getDownloadUrl()
  {
    return $this->downloadUrl;
  }
  /**
   * The end of the time period that the report instance covers. The value is
   * exclusive.
   *
   * @param string $endTime
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * The server-generated ID of the report.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * The date/time when the job this report belongs to will expire/expired.
   *
   * @param string $jobExpireTime
   */
  public function setJobExpireTime($jobExpireTime)
  {
    $this->jobExpireTime = $jobExpireTime;
  }
  /**
   * @return string
   */
  public function getJobExpireTime()
  {
    return $this->jobExpireTime;
  }
  /**
   * The ID of the job that created this report.
   *
   * @param string $jobId
   */
  public function setJobId($jobId)
  {
    $this->jobId = $jobId;
  }
  /**
   * @return string
   */
  public function getJobId()
  {
    return $this->jobId;
  }
  /**
   * The start of the time period that the report instance covers. The value is
   * inclusive.
   *
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Report::class, 'Google_Service_YouTubeReporting_Report');
